/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.bind.adapter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.openmeetings.db.util.XmlHelper;
import org.apache.wicket.util.string.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OauthMapAdapter
extends XmlAdapter<Object, Map<String, String>> {
    public Object marshal(Map<String, String> v) throws Exception {
        Document document = XmlHelper.createBuilder().newDocument();
        Element root = document.createElement("mapping");
        document.appendChild(root);
        for (Map.Entry<String, String> e : v.entrySet()) {
            Element entry = document.createElement("entry");
            Element key = document.createElement("key");
            key.setTextContent(e.getKey());
            entry.appendChild(key);
            Element value = document.createElement("value");
            value.setTextContent(e.getValue());
            entry.appendChild(value);
            root.appendChild(entry);
        }
        return root;
    }

    private static void putValue(Map<String, String> map, String key, String value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            map.put(key, value);
        }
    }

    private static Map<String, String> getMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        OauthMapAdapter.putValue(map, key, value);
        return map;
    }

    private static Map<String, String> getMap(NodeList entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            NodeList children = entry.getChildNodes();
            if (!"entry".equals(entry.getLocalName()) || children.getLength() <= 1) continue;
            Node key = null;
            Node value = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node n = children.item(j);
                if (n.getNodeType() == 3) continue;
                if (key == null) {
                    key = n;
                    continue;
                }
                value = n;
                break;
            }
            if (key == null || value == null) continue;
            OauthMapAdapter.putValue(map, key.getTextContent(), value.getTextContent());
        }
        return map;
    }

    public Map<String, String> unmarshal(Object v) throws Exception {
        Element el = (Element)v;
        if ("loginParamName".equals(el.getLocalName())) {
            return OauthMapAdapter.getMap("login", el.getTextContent());
        }
        if ("emailParamName".equals(el.getLocalName())) {
            return OauthMapAdapter.getMap("address.email", el.getTextContent());
        }
        if ("firstnameParamName".equals(el.getLocalName())) {
            return OauthMapAdapter.getMap("firstname", el.getTextContent());
        }
        if ("lastnameParamName".equals(el.getLocalName())) {
            return OauthMapAdapter.getMap("lastname", el.getTextContent());
        }
        if ("mapping".equals(el.getLocalName())) {
            return OauthMapAdapter.getMap(el.getChildNodes());
        }
        return Map.of();
    }
}

