/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.room;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.bind.adapter.BooleanAdapter;
import org.apache.openmeetings.db.bind.adapter.IntAdapter;
import org.apache.openmeetings.db.bind.adapter.LongAdapter;
import org.apache.openmeetings.db.bind.adapter.RoomElementAdapter;
import org.apache.openmeetings.db.bind.adapter.RoomTypeAdapter;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.user.Group;

@Entity
@FetchGroups(value={@FetchGroup(name="roomModerators", attributes={@FetchAttribute(name="moderators")}), @FetchGroup(name="roomGroups", attributes={@FetchAttribute(name="groups")}), @FetchGroup(name="roomFiles", attributes={@FetchAttribute(name="files")})})
@NamedQueries(value={@NamedQuery(name="getNondeletedRooms", query="SELECT r FROM Room r WHERE r.deleted = false"), @NamedQuery(name="getPublicRooms", query="SELECT r from Room r WHERE r.ispublic = true and r.deleted = false and r.type = :type"), @NamedQuery(name="getRoomByOwnerAndTypeId", query="SELECT r FROM Room as r WHERE r.ownerId = :ownerId AND r.type = :type AND r.deleted = false"), @NamedQuery(name="selectMaxFromRooms", query="SELECT COUNT(r.id) from Room r WHERE r.deleted = false AND r.name LIKE :search "), @NamedQuery(name="getExternalRoom", query="SELECT rg.room FROM RoomGroup rg WHERE rg.group.deleted = false AND rg.group.external = true AND rg.group.name = :externalType AND rg.room.deleted = false AND rg.room.type = :type AND rg.room.externalId = :externalId"), @NamedQuery(name="getExternalRoomNoType", query="SELECT rg.room FROM RoomGroup rg WHERE rg.group.deleted = false AND rg.group.external = true AND rg.group.name = :externalType AND rg.room.deleted = false AND rg.room.externalId = :externalId"), @NamedQuery(name="getPublicRoomsOrdered", query="SELECT r from Room r WHERE r.ispublic= true AND r.deleted= false AND r.appointment = false ORDER BY r.name ASC"), @NamedQuery(name="getRoomById", query="SELECT r FROM Room r WHERE r.deleted = false AND r.id = :id"), @NamedQuery(name="getRoomsByIds", query="SELECT r FROM Room r WHERE r.deleted = false AND r.id IN :ids"), @NamedQuery(name="getRoomByTag", query="SELECT r FROM Room r WHERE r.deleted = false AND r.tag = :tag"), @NamedQuery(name="getSipRoomIdsByIds", query="SELECT r.id FROM Room r WHERE r.deleted = false AND r.sipEnabled = true AND r.id IN :ids"), @NamedQuery(name="countRooms", query="SELECT COUNT(r) FROM Room r WHERE r.deleted = false"), @NamedQuery(name="getBackupRooms", query="SELECT r FROM Room r ORDER BY r.id"), @NamedQuery(name="getGroupRooms", query="SELECT DISTINCT rg.room FROM RoomGroup rg LEFT JOIN FETCH rg.room WHERE rg.group.id = :groupId AND rg.room.deleted = false AND rg.room.appointment = false ORDER BY rg.room.name ASC")})
@Table(name="room", indexes={@Index(name="room_name_idx", columnList="name")})
@XmlRootElement(name="room")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Room
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int CONFERENCE_TYPE_ID = 1;
    public static final int PRESENTATION_TYPE_ID = 3;
    public static final int INTERVIEW_TYPE_ID = 4;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @XmlElement(name="rooms_id", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long id;
    @Column(name="name")
    @XmlElement(name="name", required=false)
    private String name;
    @Column(name="tag", length=10)
    @XmlElement(name="tag", required=false)
    private String tag;
    @Lob
    @Column(name="comment")
    @XmlElement(name="comment", required=false)
    private String comment;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    @XmlElement(name="roomtypeId", required=false)
    @XmlJavaTypeAdapter(value=RoomTypeAdapter.class)
    private Type type = Type.CONFERENCE;
    @Column(name="ispublic", nullable=false)
    @XmlElement(name="ispublic", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean ispublic;
    @Column(name="capacity")
    @XmlElement(name="numberOfPartizipants", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class, type=long.class)
    private long capacity = 4L;
    @Column(name="appointment", nullable=false)
    @XmlElement(name="appointment", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean appointment;
    @Column(name="external_id")
    @XmlElement(name="externalId", required=false)
    private String externalId;
    @XmlElement(name="externalType", required=false)
    @Transient
    @Deprecated(since="5.0")
    private String externalType;
    @Column(name="demo_room", nullable=false)
    @XmlElement(name="isDemoRoom", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean demoRoom;
    @Column(name="demo_time")
    @XmlElement(name="demoTime", required=false)
    @XmlJavaTypeAdapter(value=IntAdapter.class)
    private Integer demoTime;
    @Column(name="moderated", nullable=false)
    @XmlElement(name="isModeratedRoom", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean moderated;
    @Column(name="wait_moderator", nullable=false)
    @XmlElement(name="waitModerator", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean waitModerator;
    @Column(name="allow_user_questions", nullable=false)
    @XmlElement(name="allowUserQuestions", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean allowUserQuestions;
    @Column(name="audio_only", nullable=false)
    @XmlElement(name="isAudioOnly", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean audioOnly;
    @Column(name="closed", nullable=false)
    @XmlElement(name="closed", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean closed;
    @Column(name="redirect_url")
    @XmlElement(name="redirectURL", required=false)
    private String redirectURL;
    @Column(name="owner_id")
    @XmlElement(name="ownerid", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long ownerId;
    @Column(name="wait_for_recording", nullable=false)
    @XmlElement(name="waitRecording", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean waitRecording;
    @Column(name="allow_recording", nullable=false)
    @XmlElement(name="allowRecording", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean allowRecording = true;
    @Column(name="chat_moderated", nullable=false)
    @XmlElement(name="chatModerated", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean chatModerated;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="hide_element")
    @CollectionTable(name="room_hide_element", joinColumns={@JoinColumn(name="room_id")})
    @Enumerated(value=EnumType.STRING)
    @XmlElementWrapper(name="hide_element", required=false)
    @XmlElement(name="roomElement")
    @XmlJavaTypeAdapter(value=RoomElementAdapter.class)
    private Set<RoomElement> hiddenElements = new HashSet<RoomElement>();
    @Column(name="chat_opened", nullable=false)
    @XmlElement(name="chatOpened", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean chatOpened;
    @Column(name="files_opened", nullable=false)
    @XmlElement(name="filesOpened", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean filesOpened;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="roomId")
    @ForeignKey(enabled=true)
    @XmlElementWrapper(name="room_moderators", required=false)
    @XmlElement(name="room_moderator", required=false)
    private List<RoomModerator> moderators = new ArrayList<RoomModerator>();
    @Column(name="sip_enabled", nullable=false)
    @XmlElement(name="sipEnabled", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean sipEnabled;
    @Column(name="confno")
    @XmlElement(name="confno", required=false)
    private String confno;
    @Column(name="pin")
    @XmlElement(name="pin", required=false)
    private String pin;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="room_id", insertable=true, updatable=true)
    @ElementDependent
    @XmlTransient
    private List<RoomGroup> groups = new ArrayList<RoomGroup>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="room_id", insertable=true, updatable=true, nullable=false)
    @ElementDependent
    @XmlTransient
    private List<RoomFile> files = new ArrayList<RoomFile>();
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$HistoricalEntity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$room$Room$Type;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$room$Room;

    public String getComment() {
        return Room.pcGetcomment(this);
    }

    public void setComment(String comment) {
        Room.pcSetcomment(this, comment);
    }

    public String getName() {
        return Room.pcGetname(this);
    }

    public void setName(String name) {
        Room.pcSetname(this, name);
    }

    public String getTag() {
        return Room.pcGettag(this);
    }

    public void setTag(String tag) {
        Room.pcSettag(this, tag);
    }

    @Override
    public Long getId() {
        return Room.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Room.pcSetid(this, id);
    }

    public Type getType() {
        return Room.pcGettype(this);
    }

    public void setType(Type type) {
        Room.pcSettype(this, type);
    }

    public boolean getIspublic() {
        return Room.pcGetispublic(this);
    }

    public void setIspublic(boolean ispublic) {
        Room.pcSetispublic(this, ispublic);
    }

    public long getCapacity() {
        return Room.pcGetcapacity(this);
    }

    public void setCapacity(long capacity) {
        Room.pcSetcapacity(this, capacity);
    }

    public boolean isAppointment() {
        return Room.pcGetappointment(this);
    }

    public void setAppointment(boolean appointment) {
        Room.pcSetappointment(this, appointment);
    }

    public boolean isDemoRoom() {
        return Room.pcGetdemoRoom(this);
    }

    public void setDemoRoom(boolean demoRoom) {
        Room.pcSetdemoRoom(this, demoRoom);
    }

    public Integer getDemoTime() {
        return Room.pcGetdemoTime(this);
    }

    public void setDemoTime(Integer demoTime) {
        Room.pcSetdemoTime(this, demoTime);
    }

    public boolean isModerated() {
        return Room.pcGetmoderated(this);
    }

    public void setModerated(boolean moderated) {
        Room.pcSetmoderated(this, moderated);
    }

    public boolean isWaitModerator() {
        return Room.pcGetwaitModerator(this);
    }

    public void setWaitModerator(boolean waitModerator) {
        Room.pcSetwaitModerator(this, waitModerator);
    }

    public String getExternalId() {
        return Room.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        Room.pcSetexternalId(this, externalId);
    }

    public String externalType() {
        Optional extType = Room.pcGetgroups(this) == null ? Optional.empty() : Room.pcGetgroups(this).stream().filter(rg -> rg.getGroup().isExternal()).findFirst().map(gu -> gu.getGroup().getName());
        return extType.isPresent() ? (String)extType.get() : null;
    }

    @Deprecated(since="5.0")
    public String getExternalType() {
        return this.externalType;
    }

    @Deprecated(since="5.0")
    public void setExternalType(String externalType) {
        this.externalType = externalType;
    }

    public boolean isAllowUserQuestions() {
        return Room.pcGetallowUserQuestions(this);
    }

    public void setAllowUserQuestions(boolean allowUserQuestions) {
        Room.pcSetallowUserQuestions(this, allowUserQuestions);
    }

    public boolean isAudioOnly() {
        return Room.pcGetaudioOnly(this);
    }

    public void setAudioOnly(boolean audioOnly) {
        Room.pcSetaudioOnly(this, audioOnly);
    }

    public boolean isClosed() {
        return Room.pcGetclosed(this);
    }

    public void setClosed(boolean closed) {
        Room.pcSetclosed(this, closed);
    }

    public String getRedirectURL() {
        return Room.pcGetredirectURL(this);
    }

    public void setRedirectURL(String redirectURL) {
        Room.pcSetredirectURL(this, redirectURL);
    }

    public Long getOwnerId() {
        return Room.pcGetownerId(this);
    }

    public void setOwnerId(Long ownerId) {
        Room.pcSetownerId(this, ownerId);
    }

    public boolean isWaitRecording() {
        return Room.pcGetwaitRecording(this);
    }

    public void setWaitRecording(boolean waitRecording) {
        Room.pcSetwaitRecording(this, waitRecording);
    }

    public boolean isAllowRecording() {
        return Room.pcGetallowRecording(this);
    }

    public void setAllowRecording(boolean allowRecording) {
        Room.pcSetallowRecording(this, allowRecording);
    }

    public List<RoomModerator> getModerators() {
        return Room.pcGetmoderators(this);
    }

    public void setModerators(List<RoomModerator> moderators) {
        if (moderators != null) {
            Room.pcSetmoderators(this, moderators);
        }
    }

    public boolean isChatModerated() {
        return Room.pcGetchatModerated(this);
    }

    public void setChatModerated(boolean chatModerated) {
        Room.pcSetchatModerated(this, chatModerated);
    }

    public Set<RoomElement> getHiddenElements() {
        return Room.pcGethiddenElements(this);
    }

    public void setHiddenElements(Set<RoomElement> hiddenElements) {
        Room.pcSethiddenElements(this, hiddenElements);
    }

    public boolean isHidden(RoomElement e) {
        return Room.pcGethiddenElements(this) != null && Room.pcGethiddenElements(this).contains((Object)e);
    }

    public boolean hide(RoomElement e) {
        if (Room.pcGethiddenElements(this) == null) {
            Room.pcSethiddenElements(this, new HashSet());
        }
        return Room.pcGethiddenElements(this).add(e);
    }

    public List<RoomGroup> getGroups() {
        return Room.pcGetgroups(this);
    }

    public void addGroup(Group g) {
        if (Room.pcGetgroups(this) == null) {
            Room.pcSetgroups(this, new ArrayList());
        }
        Room.pcGetgroups(this).add(new RoomGroup(g, this));
    }

    public void setGroups(List<RoomGroup> groups) {
        Room.pcSetgroups(this, groups);
    }

    public boolean isChatOpened() {
        return Room.pcGetchatOpened(this);
    }

    public void setChatOpened(boolean chatOpened) {
        Room.pcSetchatOpened(this, chatOpened);
    }

    public boolean isFilesOpened() {
        return Room.pcGetfilesOpened(this);
    }

    public void setFilesOpened(boolean filesOpened) {
        Room.pcSetfilesOpened(this, filesOpened);
    }

    public boolean isSipEnabled() {
        return Room.pcGetsipEnabled(this);
    }

    public void setSipEnabled(boolean sipEnabled) {
        Room.pcSetsipEnabled(this, sipEnabled);
    }

    public String getConfno() {
        return Room.pcGetconfno(this);
    }

    public void setConfno(String confno) {
        Room.pcSetconfno(this, confno);
    }

    public String getPin() {
        return Room.pcGetpin(this);
    }

    public void setPin(String pin) {
        Room.pcSetpin(this, pin);
    }

    public List<RoomFile> getFiles() {
        return Room.pcGetfiles(this);
    }

    public void setFiles(List<RoomFile> files) {
        Room.pcSetfiles(this, files);
    }

    public boolean isOwner(Long userId) {
        return Room.pcGetownerId(this) != null && Room.pcGetownerId(this).equals(userId);
    }

    public String toString() {
        return "Room [id=" + Room.pcGetid(this) + ", name=" + Room.pcGetname(this) + ", type=" + Room.pcGettype(this) + "]";
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$HistoricalEntity != null ? class$Lorg$apache$openmeetings$db$entity$HistoricalEntity : (class$Lorg$apache$openmeetings$db$entity$HistoricalEntity = Room.class$("org.apache.openmeetings.db.entity.HistoricalEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"allowRecording", "allowUserQuestions", "appointment", "audioOnly", "capacity", "chatModerated", "chatOpened", "closed", "comment", "confno", "demoRoom", "demoTime", "externalId", "files", "filesOpened", "groups", "hiddenElements", "id", "ispublic", "moderated", "moderators", "name", "ownerId", "pin", "redirectURL", "sipEnabled", "tag", "type", "waitModerator", "waitRecording"};
        Class[] classArray = new Class[30];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Long.TYPE;
        classArray[5] = Boolean.TYPE;
        classArray[6] = Boolean.TYPE;
        classArray[7] = Boolean.TYPE;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[8] = clazz2;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[10] = Boolean.TYPE;
        Class clazz3 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Room.class$("java.lang.Integer"));
        classArray[11] = clazz3;
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        classArray[13] = clazz4;
        classArray[14] = Boolean.TYPE;
        classArray[15] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        Class clazz5 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = Room.class$("java.util.Set"));
        classArray[16] = clazz5;
        Class clazz6 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Room.class$("java.lang.Long"));
        classArray[17] = clazz6;
        classArray[18] = Boolean.TYPE;
        classArray[19] = Boolean.TYPE;
        classArray[20] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[22] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Room.class$("java.lang.Long"));
        classArray[23] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[24] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[25] = Boolean.TYPE;
        classArray[26] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$room$Room$Type != null ? class$Lorg$apache$openmeetings$db$entity$room$Room$Type : (class$Lorg$apache$openmeetings$db$entity$room$Room$Type = Room.class$("org.apache.openmeetings.db.entity.room.Room$Type"));
        classArray[27] = clazz7;
        classArray[28] = Boolean.TYPE;
        classArray[29] = Boolean.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 5, 10, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Room", (PersistenceCapable)new Room());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.allowRecording = false;
        this.allowUserQuestions = false;
        this.appointment = false;
        this.audioOnly = false;
        this.capacity = 0L;
        this.chatModerated = false;
        this.chatOpened = false;
        this.closed = false;
        this.comment = null;
        this.confno = null;
        this.demoRoom = false;
        this.demoTime = null;
        this.externalId = null;
        this.files = null;
        this.filesOpened = false;
        this.groups = null;
        this.hiddenElements = null;
        this.id = null;
        this.ispublic = false;
        this.moderated = false;
        this.moderators = null;
        this.name = null;
        this.ownerId = null;
        this.pin = null;
        this.redirectURL = null;
        this.sipEnabled = false;
        this.tag = null;
        this.type = null;
        this.waitModerator = false;
        this.waitRecording = false;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Room room = new Room();
        if (bl) {
            room.pcClearFields();
        }
        room.pcStateManager = stateManager;
        room.pcCopyKeyFieldsFromObjectId(object);
        return room;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Room room = new Room();
        if (bl) {
            room.pcClearFields();
        }
        room.pcStateManager = stateManager;
        return room;
    }

    protected static int pcGetManagedFieldCount() {
        return 30 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowRecording = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.allowUserQuestions = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.appointment = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.audioOnly = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.capacity = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.chatModerated = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.chatOpened = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.closed = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.comment = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.confno = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.demoRoom = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.demoTime = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.files = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.filesOpened = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.groups = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.hiddenElements = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.ispublic = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.moderated = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.moderators = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.ownerId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.pin = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.redirectURL = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.sipEnabled = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.tag = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.type = (Type)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 28: {
                this.waitModerator = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.waitRecording = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowRecording);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowUserQuestions);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.appointment);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.audioOnly);
                return;
            }
            case 4: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.capacity);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.chatModerated);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.chatOpened);
                return;
            }
            case 7: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.closed);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.comment);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.confno);
                return;
            }
            case 10: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.demoRoom);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.demoTime);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.files);
                return;
            }
            case 14: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.filesOpened);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.groups);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.hiddenElements);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 18: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.ispublic);
                return;
            }
            case 19: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.moderated);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.moderators);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ownerId);
                return;
            }
            case 23: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pin);
                return;
            }
            case 24: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.redirectURL);
                return;
            }
            case 25: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.sipEnabled);
                return;
            }
            case 26: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.tag);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 28: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.waitModerator);
                return;
            }
            case 29: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.waitRecording);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Room room, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(room, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowRecording = room.allowRecording;
                return;
            }
            case 1: {
                this.allowUserQuestions = room.allowUserQuestions;
                return;
            }
            case 2: {
                this.appointment = room.appointment;
                return;
            }
            case 3: {
                this.audioOnly = room.audioOnly;
                return;
            }
            case 4: {
                this.capacity = room.capacity;
                return;
            }
            case 5: {
                this.chatModerated = room.chatModerated;
                return;
            }
            case 6: {
                this.chatOpened = room.chatOpened;
                return;
            }
            case 7: {
                this.closed = room.closed;
                return;
            }
            case 8: {
                this.comment = room.comment;
                return;
            }
            case 9: {
                this.confno = room.confno;
                return;
            }
            case 10: {
                this.demoRoom = room.demoRoom;
                return;
            }
            case 11: {
                this.demoTime = room.demoTime;
                return;
            }
            case 12: {
                this.externalId = room.externalId;
                return;
            }
            case 13: {
                this.files = room.files;
                return;
            }
            case 14: {
                this.filesOpened = room.filesOpened;
                return;
            }
            case 15: {
                this.groups = room.groups;
                return;
            }
            case 16: {
                this.hiddenElements = room.hiddenElements;
                return;
            }
            case 17: {
                this.id = room.id;
                return;
            }
            case 18: {
                this.ispublic = room.ispublic;
                return;
            }
            case 19: {
                this.moderated = room.moderated;
                return;
            }
            case 20: {
                this.moderators = room.moderators;
                return;
            }
            case 21: {
                this.name = room.name;
                return;
            }
            case 22: {
                this.ownerId = room.ownerId;
                return;
            }
            case 23: {
                this.pin = room.pin;
                return;
            }
            case 24: {
                this.redirectURL = room.redirectURL;
                return;
            }
            case 25: {
                this.sipEnabled = room.sipEnabled;
                return;
            }
            case 26: {
                this.tag = room.tag;
                return;
            }
            case 27: {
                this.type = room.type;
                return;
            }
            case 28: {
                this.waitModerator = room.waitModerator;
                return;
            }
            case 29: {
                this.waitRecording = room.waitRecording;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Room room = (Room)object;
        if (room.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(room, nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(17 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        return new LongId(clazz, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        return new LongId(clazz, this.id);
    }

    private static final boolean pcGetallowRecording(Room room) {
        if (room.pcStateManager == null) {
            return room.allowRecording;
        }
        int n = pcInheritedFieldCount + 0;
        room.pcStateManager.accessingField(n);
        return room.allowRecording;
    }

    private static final void pcSetallowRecording(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.allowRecording = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 0, room.allowRecording, bl, 0);
    }

    private static final boolean pcGetallowUserQuestions(Room room) {
        if (room.pcStateManager == null) {
            return room.allowUserQuestions;
        }
        int n = pcInheritedFieldCount + 1;
        room.pcStateManager.accessingField(n);
        return room.allowUserQuestions;
    }

    private static final void pcSetallowUserQuestions(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.allowUserQuestions = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 1, room.allowUserQuestions, bl, 0);
    }

    private static final boolean pcGetappointment(Room room) {
        if (room.pcStateManager == null) {
            return room.appointment;
        }
        int n = pcInheritedFieldCount + 2;
        room.pcStateManager.accessingField(n);
        return room.appointment;
    }

    private static final void pcSetappointment(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.appointment = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 2, room.appointment, bl, 0);
    }

    private static final boolean pcGetaudioOnly(Room room) {
        if (room.pcStateManager == null) {
            return room.audioOnly;
        }
        int n = pcInheritedFieldCount + 3;
        room.pcStateManager.accessingField(n);
        return room.audioOnly;
    }

    private static final void pcSetaudioOnly(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.audioOnly = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 3, room.audioOnly, bl, 0);
    }

    private static final long pcGetcapacity(Room room) {
        if (room.pcStateManager == null) {
            return room.capacity;
        }
        int n = pcInheritedFieldCount + 4;
        room.pcStateManager.accessingField(n);
        return room.capacity;
    }

    private static final void pcSetcapacity(Room room, long l) {
        if (room.pcStateManager == null) {
            room.capacity = l;
            return;
        }
        room.pcStateManager.settingLongField((PersistenceCapable)room, pcInheritedFieldCount + 4, room.capacity, l, 0);
    }

    private static final boolean pcGetchatModerated(Room room) {
        if (room.pcStateManager == null) {
            return room.chatModerated;
        }
        int n = pcInheritedFieldCount + 5;
        room.pcStateManager.accessingField(n);
        return room.chatModerated;
    }

    private static final void pcSetchatModerated(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.chatModerated = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 5, room.chatModerated, bl, 0);
    }

    private static final boolean pcGetchatOpened(Room room) {
        if (room.pcStateManager == null) {
            return room.chatOpened;
        }
        int n = pcInheritedFieldCount + 6;
        room.pcStateManager.accessingField(n);
        return room.chatOpened;
    }

    private static final void pcSetchatOpened(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.chatOpened = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 6, room.chatOpened, bl, 0);
    }

    private static final boolean pcGetclosed(Room room) {
        if (room.pcStateManager == null) {
            return room.closed;
        }
        int n = pcInheritedFieldCount + 7;
        room.pcStateManager.accessingField(n);
        return room.closed;
    }

    private static final void pcSetclosed(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.closed = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 7, room.closed, bl, 0);
    }

    private static final String pcGetcomment(Room room) {
        if (room.pcStateManager == null) {
            return room.comment;
        }
        int n = pcInheritedFieldCount + 8;
        room.pcStateManager.accessingField(n);
        return room.comment;
    }

    private static final void pcSetcomment(Room room, String string) {
        if (room.pcStateManager == null) {
            room.comment = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 8, room.comment, string, 0);
    }

    private static final String pcGetconfno(Room room) {
        if (room.pcStateManager == null) {
            return room.confno;
        }
        int n = pcInheritedFieldCount + 9;
        room.pcStateManager.accessingField(n);
        return room.confno;
    }

    private static final void pcSetconfno(Room room, String string) {
        if (room.pcStateManager == null) {
            room.confno = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 9, room.confno, string, 0);
    }

    private static final boolean pcGetdemoRoom(Room room) {
        if (room.pcStateManager == null) {
            return room.demoRoom;
        }
        int n = pcInheritedFieldCount + 10;
        room.pcStateManager.accessingField(n);
        return room.demoRoom;
    }

    private static final void pcSetdemoRoom(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.demoRoom = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 10, room.demoRoom, bl, 0);
    }

    private static final Integer pcGetdemoTime(Room room) {
        if (room.pcStateManager == null) {
            return room.demoTime;
        }
        int n = pcInheritedFieldCount + 11;
        room.pcStateManager.accessingField(n);
        return room.demoTime;
    }

    private static final void pcSetdemoTime(Room room, Integer n) {
        if (room.pcStateManager == null) {
            room.demoTime = n;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 11, (Object)room.demoTime, (Object)n, 0);
    }

    private static final String pcGetexternalId(Room room) {
        if (room.pcStateManager == null) {
            return room.externalId;
        }
        int n = pcInheritedFieldCount + 12;
        room.pcStateManager.accessingField(n);
        return room.externalId;
    }

    private static final void pcSetexternalId(Room room, String string) {
        if (room.pcStateManager == null) {
            room.externalId = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 12, room.externalId, string, 0);
    }

    private static final List pcGetfiles(Room room) {
        if (room.pcStateManager == null) {
            return room.files;
        }
        int n = pcInheritedFieldCount + 13;
        room.pcStateManager.accessingField(n);
        return room.files;
    }

    private static final void pcSetfiles(Room room, List list) {
        if (room.pcStateManager == null) {
            room.files = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 13, room.files, (Object)list, 0);
    }

    private static final boolean pcGetfilesOpened(Room room) {
        if (room.pcStateManager == null) {
            return room.filesOpened;
        }
        int n = pcInheritedFieldCount + 14;
        room.pcStateManager.accessingField(n);
        return room.filesOpened;
    }

    private static final void pcSetfilesOpened(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.filesOpened = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 14, room.filesOpened, bl, 0);
    }

    private static final List pcGetgroups(Room room) {
        if (room.pcStateManager == null) {
            return room.groups;
        }
        int n = pcInheritedFieldCount + 15;
        room.pcStateManager.accessingField(n);
        return room.groups;
    }

    private static final void pcSetgroups(Room room, List list) {
        if (room.pcStateManager == null) {
            room.groups = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 15, room.groups, (Object)list, 0);
    }

    private static final Set pcGethiddenElements(Room room) {
        if (room.pcStateManager == null) {
            return room.hiddenElements;
        }
        int n = pcInheritedFieldCount + 16;
        room.pcStateManager.accessingField(n);
        return room.hiddenElements;
    }

    private static final void pcSethiddenElements(Room room, Set set) {
        if (room.pcStateManager == null) {
            room.hiddenElements = set;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 16, room.hiddenElements, (Object)set, 0);
    }

    private static final Long pcGetid(Room room) {
        if (room.pcStateManager == null) {
            return room.id;
        }
        int n = pcInheritedFieldCount + 17;
        room.pcStateManager.accessingField(n);
        return room.id;
    }

    private static final void pcSetid(Room room, Long l) {
        if (room.pcStateManager == null) {
            room.id = l;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 17, (Object)room.id, (Object)l, 0);
    }

    private static final boolean pcGetispublic(Room room) {
        if (room.pcStateManager == null) {
            return room.ispublic;
        }
        int n = pcInheritedFieldCount + 18;
        room.pcStateManager.accessingField(n);
        return room.ispublic;
    }

    private static final void pcSetispublic(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.ispublic = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 18, room.ispublic, bl, 0);
    }

    private static final boolean pcGetmoderated(Room room) {
        if (room.pcStateManager == null) {
            return room.moderated;
        }
        int n = pcInheritedFieldCount + 19;
        room.pcStateManager.accessingField(n);
        return room.moderated;
    }

    private static final void pcSetmoderated(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.moderated = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 19, room.moderated, bl, 0);
    }

    private static final List pcGetmoderators(Room room) {
        if (room.pcStateManager == null) {
            return room.moderators;
        }
        int n = pcInheritedFieldCount + 20;
        room.pcStateManager.accessingField(n);
        return room.moderators;
    }

    private static final void pcSetmoderators(Room room, List list) {
        if (room.pcStateManager == null) {
            room.moderators = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 20, room.moderators, (Object)list, 0);
    }

    private static final String pcGetname(Room room) {
        if (room.pcStateManager == null) {
            return room.name;
        }
        int n = pcInheritedFieldCount + 21;
        room.pcStateManager.accessingField(n);
        return room.name;
    }

    private static final void pcSetname(Room room, String string) {
        if (room.pcStateManager == null) {
            room.name = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 21, room.name, string, 0);
    }

    private static final Long pcGetownerId(Room room) {
        if (room.pcStateManager == null) {
            return room.ownerId;
        }
        int n = pcInheritedFieldCount + 22;
        room.pcStateManager.accessingField(n);
        return room.ownerId;
    }

    private static final void pcSetownerId(Room room, Long l) {
        if (room.pcStateManager == null) {
            room.ownerId = l;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 22, (Object)room.ownerId, (Object)l, 0);
    }

    private static final String pcGetpin(Room room) {
        if (room.pcStateManager == null) {
            return room.pin;
        }
        int n = pcInheritedFieldCount + 23;
        room.pcStateManager.accessingField(n);
        return room.pin;
    }

    private static final void pcSetpin(Room room, String string) {
        if (room.pcStateManager == null) {
            room.pin = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 23, room.pin, string, 0);
    }

    private static final String pcGetredirectURL(Room room) {
        if (room.pcStateManager == null) {
            return room.redirectURL;
        }
        int n = pcInheritedFieldCount + 24;
        room.pcStateManager.accessingField(n);
        return room.redirectURL;
    }

    private static final void pcSetredirectURL(Room room, String string) {
        if (room.pcStateManager == null) {
            room.redirectURL = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 24, room.redirectURL, string, 0);
    }

    private static final boolean pcGetsipEnabled(Room room) {
        if (room.pcStateManager == null) {
            return room.sipEnabled;
        }
        int n = pcInheritedFieldCount + 25;
        room.pcStateManager.accessingField(n);
        return room.sipEnabled;
    }

    private static final void pcSetsipEnabled(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.sipEnabled = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 25, room.sipEnabled, bl, 0);
    }

    private static final String pcGettag(Room room) {
        if (room.pcStateManager == null) {
            return room.tag;
        }
        int n = pcInheritedFieldCount + 26;
        room.pcStateManager.accessingField(n);
        return room.tag;
    }

    private static final void pcSettag(Room room, String string) {
        if (room.pcStateManager == null) {
            room.tag = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 26, room.tag, string, 0);
    }

    private static final Type pcGettype(Room room) {
        if (room.pcStateManager == null) {
            return room.type;
        }
        int n = pcInheritedFieldCount + 27;
        room.pcStateManager.accessingField(n);
        return room.type;
    }

    private static final void pcSettype(Room room, Type type) {
        if (room.pcStateManager == null) {
            room.type = type;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 27, (Object)room.type, (Object)type, 0);
    }

    private static final boolean pcGetwaitModerator(Room room) {
        if (room.pcStateManager == null) {
            return room.waitModerator;
        }
        int n = pcInheritedFieldCount + 28;
        room.pcStateManager.accessingField(n);
        return room.waitModerator;
    }

    private static final void pcSetwaitModerator(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.waitModerator = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 28, room.waitModerator, bl, 0);
    }

    private static final boolean pcGetwaitRecording(Room room) {
        if (room.pcStateManager == null) {
            return room.waitRecording;
        }
        int n = pcInheritedFieldCount + 29;
        room.pcStateManager.accessingField(n);
        return room.waitRecording;
    }

    private static final void pcSetwaitRecording(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.waitRecording = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 29, room.waitRecording, bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.room.type")
    public static enum Type {
        CONFERENCE(1),
        PRESENTATION(3),
        INTERVIEW(4);

        private int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Type get(Long type) {
            return Type.get(type == null ? 1 : type.intValue());
        }

        public static Type get(Integer type) {
            return Type.get(type == null ? 1 : type);
        }

        public static Type get(int type) {
            Type rt = CONFERENCE;
            switch (type) {
                case 3: {
                    rt = PRESENTATION;
                    break;
                }
                case 4: {
                    rt = INTERVIEW;
                    break;
                }
            }
            return rt;
        }
    }

    @XmlType(namespace="org.apache.openmeetings.room.element")
    public static enum RoomElement {
        TOP_BAR,
        CHAT,
        ACTIVITIES,
        FILES,
        ACTION_MENU,
        POLL_MENU,
        SCREEN_SHARING,
        WHITEBOARD,
        MICROPHONE_STATUS,
        USER_COUNT;

    }

    @XmlType(namespace="org.apache.openmeetings.room.right")
    public static enum Right {
        SUPER_MODERATOR,
        MODERATOR,
        PRESENTER,
        WHITEBOARD,
        SHARE,
        REMOTE_CONTROL,
        AUDIO,
        VIDEO,
        MUTE_OTHERS;

    }
}

