/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.model.BaseModel;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class DocumentCategorizerTrainer
extends CasConsumer_ImplBase {
    private UimaContext mContext;
    private Logger mLogger;
    private String mModelName;
    private List<DocumentSample> documentSamples = new ArrayList<DocumentSample>();
    private Type mTokenType;
    private Type mCategoryType;
    private Feature mCategoryFeature;
    private String language;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Doccat Trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String categoryTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryType");
        this.mCategoryType = CasConsumerUtil.getType(typeSystem, categoryTypeName);
        String categoryFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.doccat.CategoryFeature");
        this.mCategoryFeature = this.mCategoryType.getFeatureByBaseName(categoryFeatureName);
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        AnnotationIndex categoryIndex = cas.getAnnotationIndex(this.mCategoryType);
        if (categoryIndex.size() > 0) {
            AnnotationFS categoryAnnotation = (AnnotationFS)categoryIndex.iterator().next();
            DocumentSample sample = new DocumentSample(categoryAnnotation.getStringValue(this.mCategoryFeature), cas.getDocumentText());
            this.documentSamples.add(sample);
        }
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        DoccatModel categoryModel = DocumentCategorizerME.train((String)this.language, (ObjectStream)ObjectStreamUtils.createObjectStream(this.documentSamples));
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize((BaseModel)categoryModel, modelFile);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.documentSamples = null;
    }
}

