/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.glassfish.grizzly.http.server.Request;

@Provider
public class AuthenticationFilter
implements ContainerRequestFilter {
    @Inject
    javax.inject.Provider<Request> _requestProvider;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Context
    ResourceInfo _resourceInfo;
    @Context
    HttpHeaders _httpHeaders;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method endpointMethod = this._resourceInfo.getResourceMethod();
        if (endpointMethod.isAnnotationPresent(Authenticate.class)) {
            AccessControlUtils accessControlUtils = new AccessControlUtils();
            AccessType accessType = endpointMethod.getAnnotation(Authenticate.class).value();
            String endpointUrl = ((Request)this._requestProvider.get()).getRequestURL().toString();
            UriInfo uriInfo = requestContext.getUriInfo();
            Optional<String> tableName = this.extractTableName((MultivaluedMap<String, String>)uriInfo.getPathParameters(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
            accessControlUtils.validatePermission(tableName, accessType, this._httpHeaders, endpointUrl, this._accessControlFactory.create());
        }
    }

    @VisibleForTesting
    Optional<String> extractTableName(MultivaluedMap<String, String> pathParameters, MultivaluedMap<String, String> queryParameters) {
        Optional<String> tableName = this.extractTableName(pathParameters);
        if (tableName.isPresent()) {
            return tableName;
        }
        return this.extractTableName(queryParameters);
    }

    private Optional<String> extractTableName(MultivaluedMap<String, String> mmap) {
        String tableName = (String)mmap.getFirst((Object)"tableName");
        if (tableName == null && (tableName = (String)mmap.getFirst((Object)"tableNameWithType")) == null) {
            tableName = (String)mmap.getFirst((Object)"schemaName");
        }
        return Optional.ofNullable(tableName);
    }
}

