/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.FileIngestionHelper;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotIngestionRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotIngestionRestletResource.class);
    private static final String UPLOAD_DIR = "upload_dir";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/ingestFromFile")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Ingest a file", notes="Creates a segment using given file and pushes it to Pinot. \n All steps happen on the controller. This API is NOT meant for production environments/large input files. \n Example usage (query params need encoding):\n```\ncurl -X POST -F file=@data.json -H \"Content-Type: multipart/form-data\" \"http://localhost:9000/ingestFromFile?tableNameWithType=foo_OFFLINE&\nbatchConfigMapStr={\n  \"inputFormat\":\"csv\",\n  \"recordReader.prop.delimiter\":\"|\"\n}\" \n```")
    public void ingestFromFile(@ApiParam(value="Name of the table to upload the file to", required=true) @QueryParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Batch config Map as json string. Must pass inputFormat, and optionally record reader properties. e.g. {\"inputFormat\":\"json\"}", required=true) @QueryParam(value="batchConfigMapStr") String batchConfigMapStr, FormDataMultiPart fileUpload, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.ingestData(tableNameWithType, batchConfigMapStr, new FileIngestionHelper.DataPayload(fileUpload)));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new ControllerApplicationException(LOGGER, String.format("Caught exception when ingesting file into table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e)));
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/ingestFromURI")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Ingest from the given URI", notes="Creates a segment using file at the given URI and pushes it to Pinot. \n All steps happen on the controller. This API is NOT meant for production environments/large input files. \nExample usage (query params need encoding):\n```\ncurl -X POST \"http://localhost:9000/ingestFromURI?tableNameWithType=foo_OFFLINE\n&batchConfigMapStr={\n  \"inputFormat\":\"json\",\n  \"input.fs.className\":\"org.apache.pinot.plugin.filesystem.S3PinotFS\",\n  \"input.fs.prop.region\":\"us-central\",\n  \"input.fs.prop.accessKey\":\"foo\",\n  \"input.fs.prop.secretKey\":\"bar\"\n}\n&sourceURIStr=s3://test.bucket/path/to/json/data/data.json\"\n```")
    public void ingestFromURI(@ApiParam(value="Name of the table to upload the file to", required=true) @QueryParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Batch config Map as json string. Must pass inputFormat, and optionally input FS properties. e.g. {\"inputFormat\":\"json\"}", required=true) @QueryParam(value="batchConfigMapStr") String batchConfigMapStr, @ApiParam(value="URI of file to upload", required=true) @QueryParam(value="sourceURIStr") String sourceURIStr, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.ingestData(tableNameWithType, batchConfigMapStr, new FileIngestionHelper.DataPayload(new URI(sourceURIStr))));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new ControllerApplicationException(LOGGER, String.format("Caught exception when ingesting file into table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e)));
        }
    }

    private SuccessResponse ingestData(String tableNameWithType, String batchConfigMapStr, FileIngestionHelper.DataPayload payload) throws Exception {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)"Must provide table name with type suffix for table: %s", (Object)tableNameWithType);
        Preconditions.checkState((TableType.REALTIME != tableType ? 1 : 0) != 0, (String)"Cannot ingest file into REALTIME table: %s", (Object)tableNameWithType);
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Table: %s not found", (Object)tableNameWithType);
        Map batchConfigMap = (Map)JsonUtils.stringToObject((String)batchConfigMapStr, (TypeReference)new TypeReference<Map<String, String>>(){});
        BatchConfig batchConfig = new BatchConfig(tableNameWithType, batchConfigMap);
        Schema schema = this._pinotHelixResourceManager.getTableSchema(tableNameWithType);
        FileIngestionHelper fileIngestionHelper = new FileIngestionHelper(tableConfig, schema, batchConfig, this._controllerConf.getControllerHost(), Integer.parseInt(this._controllerConf.getControllerPort()), new File(this._controllerConf.getDataDir(), UPLOAD_DIR));
        return fileIngestionHelper.buildSegmentAndPush(payload);
    }
}

