/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Charsets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Zookeeper"})
@Path(value="/")
public class ZookeeperResource {
    public static Logger LOGGER = LoggerFactory.getLogger(ZookeeperResource.class);
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;
    ZNRecordSerializer _znRecordSerializer = new ZNRecordSerializer();

    @GET
    @Path(value="/zk/get")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get content of the znode")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public String getData(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path) {
        ZNRecord znRecord = this.pinotHelixResourceManager.readZKData(path = this.validateAndNormalizeZKPath(path));
        if (znRecord != null) {
            return new String(this._znRecordSerializer.serialize((Object)znRecord), StandardCharsets.UTF_8);
        }
        return null;
    }

    @DELETE
    @Path(value="/zk/delete")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the znode at this path")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse delete(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path) {
        boolean success = this.pinotHelixResourceManager.deleteZKPath(path = this.validateAndNormalizeZKPath(path));
        if (success) {
            return new SuccessResponse("Successfully deleted path: " + path);
        }
        throw new ControllerApplicationException(LOGGER, "Failed to delete path: " + path, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @PUT
    @Path(value="/zk/put")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the content of the node")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse putData(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path, @ApiParam(value="Content", required=true) @QueryParam(value="data") @DefaultValue(value="") String content, @ApiParam(value="expectedVersion", required=true, defaultValue="-1") @QueryParam(value="expectedVersion") @DefaultValue(value="-1") String expectedVersion, @ApiParam(value="accessOption", required=true, defaultValue="1") @QueryParam(value="accessOption") @DefaultValue(value="1") String accessOption) {
        path = this.validateAndNormalizeZKPath(path);
        ZNRecord record = null;
        if (content != null) {
            record = (ZNRecord)this._znRecordSerializer.deserialize(content.getBytes(Charsets.UTF_8));
        }
        try {
            boolean result = this.pinotHelixResourceManager.setZKData(path, record, Integer.parseInt(expectedVersion), Integer.parseInt(accessOption));
            if (result) {
                return new SuccessResponse("Successfully Updated path: " + path);
            }
            throw new ControllerApplicationException(LOGGER, "Failed to update path: " + path, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update path: " + path, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="/zk/ls")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the child znodes")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=500, message="Internal server error")})
    public String ls(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path) {
        path = this.validateAndNormalizeZKPath(path);
        List<String> children = this.pinotHelixResourceManager.getZKChildren(path);
        try {
            return JsonUtils.objectToString(children);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/zk/lsl")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the child znodes along with Stats")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=500, message="Internal server error")})
    public String lsl(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path) {
        path = this.validateAndNormalizeZKPath(path);
        Map<String, Stat> childrenStats = this.pinotHelixResourceManager.getZKChildrenStats(path);
        try {
            return JsonUtils.objectToString(childrenStats);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/zk/stat")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the stat", notes=" Use this api to fetch additional details of a znode such as creation time, modified time, numChildren etc ")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public String stat(@ApiParam(value="Zookeeper Path, must start with /", required=true, defaultValue="/") @QueryParam(value="path") @DefaultValue(value="") String path) {
        path = this.validateAndNormalizeZKPath(path);
        Stat stat = this.pinotHelixResourceManager.getZKStat(path);
        try {
            return JsonUtils.objectToString((Object)stat);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String validateAndNormalizeZKPath(@DefaultValue(value="") @QueryParam(value="path") @ApiParam(value="Zookeeper Path, must start with /", required=false, defaultValue="/") String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " cannot be null or empty", Response.Status.BAD_REQUEST);
        }
        if (!(path = path.trim()).startsWith("/")) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " must start with /", Response.Status.BAD_REQUEST);
        }
        if (!path.equals("/") && path.endsWith("/")) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " cannot end with /", Response.Status.BAD_REQUEST);
        }
        if (!this.pinotHelixResourceManager.getHelixZkManager().getHelixDataAccessor().getBaseDataAccessor().exists(path, -1)) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " does not exist:", Response.Status.NOT_FOUND);
        }
        return path;
    }
}

