/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.statemodel;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.pinot.controller.LeadControllerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeadControllerResourceMasterSlaveStateModelFactory
extends StateModelFactory<StateModel> {
    private final LeadControllerManager _leadControllerManager;

    public LeadControllerResourceMasterSlaveStateModelFactory(LeadControllerManager leadControllerManager) {
        this._leadControllerManager = leadControllerManager;
    }

    public StateModel createNewStateModel(String resourceName, String partitionName) {
        return new LeadControllerResourceMasterSlaveStateModel(this._leadControllerManager, partitionName);
    }

    @StateModelInfo(states={"{'MASTER','SLAVE', 'OFFLINE', 'DROPPED'}"}, initialState="OFFLINE")
    public static class LeadControllerResourceMasterSlaveStateModel
    extends StateModel {
        private static final Logger LOGGER = LoggerFactory.getLogger(LeadControllerResourceMasterSlaveStateModel.class);
        private final LeadControllerManager _leadControllerManager;
        private final String _partitionName;

        private LeadControllerResourceMasterSlaveStateModel(LeadControllerManager leadControllerManager, String partitionName) {
            this._leadControllerManager = leadControllerManager;
            this._partitionName = partitionName;
        }

        @Transition(from="OFFLINE", to="SLAVE")
        public void onBecomeSlaveFromOffline(Message message, NotificationContext context) {
            LOGGER.info("Got state transition from OFFLINE to SLAVE for partition: {}", (Object)this._partitionName);
        }

        @Transition(from="SLAVE", to="MASTER")
        public void onBecomeMasterFromSlave(Message message, NotificationContext context) {
            LOGGER.info("Got state transition from SLAVE to MASTER for partition: {}", (Object)this._partitionName);
            this._leadControllerManager.addPartitionLeader(this._partitionName);
        }

        @Transition(from="MASTER", to="SLAVE")
        public void onBecomeSlaveFromMaster(Message message, NotificationContext context) {
            LOGGER.info("Got state transition from MASTER to SLAVE for partition: {}", (Object)this._partitionName);
            this._leadControllerManager.removePartitionLeader(this._partitionName);
        }

        @Transition(from="SLAVE", to="OFFLINE")
        public void onBecomeOfflineFromSlave(Message message, NotificationContext context) {
            LOGGER.info("Got state transition from SLAVE to OFFLINE for partition: {}", (Object)this._partitionName);
        }

        @Transition(from="OFFLINE", to="DROPPED")
        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            LOGGER.info("Got state transition from OFFLINE to DROPPED for partition: {}", (Object)this._partitionName);
        }
    }
}

