/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import java.util.HashSet;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.FlagQueryRuleParams;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.requesthandler.BrokerRequestOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagQueryRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(FlagQueryRule.class);
    protected final BrokerRequestOptimizer _brokerRequestOptimizer = new BrokerRequestOptimizer();
    private final FlagQueryRuleParams _params;

    public FlagQueryRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getFlagQueryRuleParams();
    }

    @Override
    public void run() {
        for (String query : this._input.getParsedQueries()) {
            this.LOGGER.debug("Parsing query: {}", (Object)query);
            QueryContext queryContext = this._input.getQueryContext(query);
            if ((long)queryContext.getLimit() > this._params.THRESHOLD_MAX_LIMIT_SIZE) {
                this._output.getFlaggedQueries().add(query, "Warning: The size of LIMIT is longer than 100000");
            }
            if (queryContext.getFilter() == null) {
                this._output.getFlaggedQueries().add(query, "Warning: No filtering in ths query");
                continue;
            }
            HashSet usedCols = new HashSet();
            queryContext.getFilter().getColumns(usedCols);
            if (usedCols.contains(this._input.getPrimaryTimeCol())) continue;
            this._output.getFlaggedQueries().add(query, "Warning: No time column used in ths query");
        }
    }
}

