/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.PartitionRuleParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionRule.class);
    PartitionRuleParams _params;

    public KafkaPartitionRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getPartitionRuleParams();
    }

    @Override
    public void run() {
        String tableType = this._input.getTableType();
        if (tableType.equalsIgnoreCase("hybrid") || tableType.equalsIgnoreCase("realtime")) {
            if (this._input.getNumKafkaPartitions() == 0) {
                this.LOGGER.info("Recommending kafka partition configurations");
                this.LOGGER.info("*No kafka partition number found, recommending kafka partition number");
                this._output.getPartitionConfig().setNumKafkaPartitions((int)Math.ceil((double)this._input.getNumMessagesPerSecInKafkaTopic() / (double)this._params.KAFKA_NUM_MESSAGES_PER_SEC_PER_PARTITION.longValue()));
            } else {
                this._output.getPartitionConfig().setNumKafkaPartitions(this._input.getNumKafkaPartitions());
            }
        }
    }
}

