/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FixedLenBitset {
    public static final int NO_INDEX_APPLICABLE = 0;
    private long[] _bytes;
    private final int _lenOfArray;
    private final int _size;
    private int _cardinality;
    private static final int[] num_to_bits = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    public static final FixedLenBitset IMMUTABLE_EMPTY_SET = new FixedLenBitset();
    public static final int SIZE_OF_LONG = 64;

    private FixedLenBitset() {
        this._size = 0;
        this._lenOfArray = 0;
        this._bytes = null;
        this._cardinality = 0;
    }

    public boolean isEmpty() {
        return this._cardinality == 0;
    }

    public List<Integer> getOffsets() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this._size; ++i) {
            if (!this.contains(i)) continue;
            ret.add(i);
        }
        return ret;
    }

    static int countSetBitsRec(long num) {
        int ret = 0;
        while (num != 0L) {
            int nibble = (int)(num & 0xFL);
            ret += num_to_bits[nibble];
            num >>>= 4;
        }
        return ret;
    }

    public int getSize() {
        return this._size;
    }

    public int getCardinality() {
        return this._cardinality;
    }

    public FixedLenBitset(int size) {
        this._size = size;
        this._lenOfArray = (size + 64 - 1) / 64;
        this._bytes = new long[this._lenOfArray];
        this._cardinality = 0;
    }

    public void add(int n) {
        if (n >= 0 && n < this._size && !this.contains(n)) {
            int n2 = n / 64;
            this._bytes[n2] = this._bytes[n2] | 1L << n % 64;
            ++this._cardinality;
        }
    }

    public boolean contains(int n) {
        return (this._bytes[n / 64] & 1L << n % 64) != 0L;
    }

    public boolean hasCandidateDim() {
        return this._cardinality != 0;
    }

    public boolean contains(FixedLenBitset b) {
        if (b._cardinality == 0) {
            return true;
        }
        for (int i = 0; i < this._lenOfArray; ++i) {
            if ((b._bytes[i] & this._bytes[i]) == b._bytes[i]) continue;
            return false;
        }
        return true;
    }

    public FixedLenBitset union(FixedLenBitset b) {
        int i;
        if (b._cardinality == 0) {
            return this;
        }
        for (i = 0; i < this._lenOfArray; ++i) {
            int n = i;
            this._bytes[n] = this._bytes[n] | b._bytes[i];
        }
        this._cardinality = 0;
        for (i = 0; i < this._lenOfArray; ++i) {
            this._cardinality += FixedLenBitset.countSetBitsRec(this._bytes[i]);
        }
        return this;
    }

    public FixedLenBitset intersect(FixedLenBitset b) {
        int i;
        if (b._cardinality == 0) {
            Arrays.fill(this._bytes, 0L);
            return this;
        }
        for (i = 0; i < this._lenOfArray; ++i) {
            int n = i;
            this._bytes[n] = this._bytes[n] & b._bytes[i];
        }
        this._cardinality = 0;
        for (i = 0; i < this._lenOfArray; ++i) {
            this._cardinality += FixedLenBitset.countSetBitsRec(this._bytes[i]);
        }
        return this;
    }

    public String toString() {
        return "{" + this.getOffsets() + '}';
    }
}

