/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.pinot.common.http.MultiGetRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionServiceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionServiceHelper.class);
    private final Executor _executor;
    private final HttpConnectionManager _httpConnectionManager;
    private final BiMap<String, String> _endpointsToServers;

    public CompletionServiceHelper(Executor executor, HttpConnectionManager httpConnectionManager, BiMap<String, String> endpointsToServers) {
        this._executor = executor;
        this._httpConnectionManager = httpConnectionManager;
        this._endpointsToServers = endpointsToServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionServiceResponse doMultiGetRequest(List<String> serverURLs, String tableNameWithType, int timeoutMs) {
        CompletionServiceResponse completionServiceResponse = new CompletionServiceResponse();
        CompletionService completionService = new MultiGetRequest(this._executor, this._httpConnectionManager).execute(serverURLs, timeoutMs);
        for (int i = 0; i < serverURLs.size(); ++i) {
            GetMethod getMethod = null;
            try {
                getMethod = (GetMethod)completionService.take().get();
                URI uri = getMethod.getURI();
                String instance = (String)this._endpointsToServers.get((Object)String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), uri.getPort()));
                if (getMethod.getStatusCode() >= 300) {
                    LOGGER.error("Server: {} returned error: {}", (Object)instance, (Object)getMethod.getStatusCode());
                    ++completionServiceResponse._failedResponseCount;
                    continue;
                }
                completionServiceResponse._httpResponses.put(instance, getMethod.getResponseBodyAsString());
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Connection error", (Throwable)e);
                ++completionServiceResponse._failedResponseCount;
                continue;
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        int numServersResponded = completionServiceResponse._httpResponses.size();
        if (numServersResponded != serverURLs.size()) {
            LOGGER.warn("Finished reading information for table: {} with {}/{} server responses", new Object[]{tableNameWithType, numServersResponded, serverURLs.size()});
        } else {
            LOGGER.info("Finished reading information for table: {}", (Object)tableNameWithType);
        }
        return completionServiceResponse;
    }

    public static class CompletionServiceResponse {
        public Map<String, String> _httpResponses = new HashMap<String, String>();
        public int _failedResponseCount = 0;
    }
}

