/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.core.segment.name.SegmentNameGenerator;
import org.apache.pinot.core.segment.name.SimpleSegmentNameGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileIngestionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIngestionUtils.class);
    private static final long DEFAULT_RETRY_WAIT_MS = 1000L;
    private static final int DEFAULT_ATTEMPTS = 3;
    private static final FileUploadDownloadClient FILE_UPLOAD_DOWNLOAD_CLIENT = new FileUploadDownloadClient();

    private FileIngestionUtils() {
    }

    public static void copyURIToLocal(BatchConfig batchConfig, URI sourceFileURI, File destFile) throws Exception {
        String sourceFileURIScheme = sourceFileURI.getScheme();
        if (!PinotFSFactory.isSchemeSupported((String)sourceFileURIScheme)) {
            PinotFSFactory.register((String)sourceFileURIScheme, (String)batchConfig.getInputFsClassName(), (PinotConfiguration)IngestionConfigUtils.getInputFsProps((Map)batchConfig.getInputFsProps()));
        }
        PinotFSFactory.create((String)sourceFileURIScheme).copyToLocalFile(sourceFileURI, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyMultipartToLocal(FormDataMultiPart multiPart, File destFile) throws IOException {
        FormDataBodyPart formDataBodyPart = (FormDataBodyPart)((List)multiPart.getFields().values().iterator().next()).get(0);
        try (InputStream inputStream = (InputStream)formDataBodyPart.getValueAs(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(destFile);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            multiPart.cleanup();
        }
    }

    public static SegmentGeneratorConfig generateSegmentGeneratorConfig(TableConfig tableConfig, BatchConfig batchConfig, Schema schema, File inputFile, File outputSegmentDir) throws ClassNotFoundException, IOException {
        SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(tableConfig, schema);
        segmentGeneratorConfig.setTableName(tableConfig.getTableName());
        segmentGeneratorConfig.setOutDir(outputSegmentDir.getAbsolutePath());
        segmentGeneratorConfig.setInputFilePath(inputFile.getAbsolutePath());
        FileFormat fileFormat = batchConfig.getInputFormat();
        segmentGeneratorConfig.setFormat(fileFormat);
        segmentGeneratorConfig.setRecordReaderPath(RecordReaderFactory.getRecordReaderClassName((String)fileFormat.toString()));
        Map configs = batchConfig.getRecordReaderProps();
        segmentGeneratorConfig.setReaderConfig(RecordReaderFactory.getRecordReaderConfig((FileFormat)fileFormat, (Map)IngestionConfigUtils.getRecordReaderProps((Map)configs)));
        segmentGeneratorConfig.setSegmentNameGenerator((SegmentNameGenerator)new SimpleSegmentNameGenerator(tableConfig.getTableName(), String.valueOf(System.currentTimeMillis())));
        return segmentGeneratorConfig;
    }

    public static String buildSegment(SegmentGeneratorConfig segmentGeneratorConfig) throws Exception {
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        driver.init(segmentGeneratorConfig);
        driver.build();
        return driver.getSegmentName();
    }

    public static void uploadSegment(String tableNameWithType, List<File> tarFiles, String controllerHost, int controllerPort) throws RetriableOperationException, AttemptsExceededException {
        for (File tarFile : tarFiles) {
            String fileName = tarFile.getName();
            Preconditions.checkArgument((boolean)fileName.endsWith(".tar.gz"));
            String segmentName = fileName.substring(0, fileName.length() - ".tar.gz".length());
            RetryPolicies.exponentialBackoffRetryPolicy((int)3, (long)1000L, (double)5.0).attempt(() -> {
                try (FileInputStream inputStream = new FileInputStream(tarFile);){
                    SimpleHttpResponse response = FILE_UPLOAD_DOWNLOAD_CLIENT.uploadSegment(FileUploadDownloadClient.getUploadSegmentHttpURI((String)controllerHost, (int)controllerPort), segmentName, (InputStream)inputStream, tableNameWithType);
                    LOGGER.info("Response for pushing table {} segment {} - {}: {}", new Object[]{tableNameWithType, segmentName, response.getStatusCode(), response.getResponse()});
                    Boolean bl = true;
                    return bl;
                }
                catch (HttpErrorStatusException e) {
                    int statusCode = e.getStatusCode();
                    if (statusCode >= 500) {
                        LOGGER.warn("Caught temporary exception while pushing table: {} segment: {}, will retry", new Object[]{tableNameWithType, segmentName, e});
                        return false;
                    }
                    LOGGER.error("Caught permanent exception while pushing table: {} segment: {}, won't retry", new Object[]{tableNameWithType, segmentName, e});
                    throw e;
                }
            });
        }
    }
}

