/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSegmentMetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSegmentMetadataReader.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;

    public ServerSegmentMetadataReader(Executor executor, HttpConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public List<String> getSegmentMetadataFromServer(String tableNameWithType, Map<String, List<String>> serversToSegmentsMap, BiMap<String, String> endpoints, int timeoutMs) {
        LOGGER.debug("Reading segment metadata from servers for table {}.", (Object)tableNameWithType);
        ArrayList<String> serverURLs = new ArrayList<String>();
        for (Map.Entry<String, List<String>> serverToSegments : serversToSegmentsMap.entrySet()) {
            List<String> segments = serverToSegments.getValue();
            for (String segment : segments) {
                serverURLs.add(this.generateSegmentMetadataServerURL(tableNameWithType, segment, (String)endpoints.get((Object)serverToSegments.getKey())));
            }
        }
        BiMap endpointsToServers = endpoints.inverse();
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverURLs, tableNameWithType, timeoutMs);
        ArrayList<String> segmentsMetadata = new ArrayList<String>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                String segmentMetadata = streamResponse.getValue();
                segmentsMetadata.add(segmentMetadata);
            }
            catch (Exception e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.error("Unable to parse server {} / {} response due to an error: ", (Object)failedParses, (Object)serverURLs.size());
        }
        LOGGER.debug("Retrieved segment metadata from servers.");
        return segmentsMetadata;
    }

    private String generateSegmentMetadataServerURL(String tableNameWithType, String segmentName, String endpoint) {
        return String.format("%s/tables/%s/segments/%s/metadata", endpoint, tableNameWithType, segmentName);
    }
}

