/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.apache.pinot.spi.utils.TimeUtils;

public class ControllerConf
extends PinotConfiguration {
    public static final List<String> SUPPORTED_PROTOCOLS = Arrays.asList("http", "https");
    public static final String CONTROLLER_VIP_HOST = "controller.vip.host";
    public static final String CONTROLLER_VIP_PORT = "controller.vip.port";
    public static final String CONTROLLER_VIP_PROTOCOL = "controller.vip.protocol";
    public static final String CONTROLLER_BROKER_PROTOCOL = "controller.broker.protocol";
    public static final String CONTROLLER_BROKER_PORT_OVERRIDE = "controller.broker.port.override";
    public static final String CONTROLLER_BROKER_TLS_PREFIX = "controller.broker.tls";
    public static final String CONTROLLER_TLS_PREFIX = "controller.tls";
    public static final String CONTROLLER_HOST = "controller.host";
    public static final String CONTROLLER_PORT = "controller.port";
    public static final String CONTROLLER_ACCESS_PROTOCOLS = "controller.access.protocols";
    public static final String DATA_DIR = "controller.data.dir";
    public static final String LOCAL_TEMP_DIR = "controller.local.temp.dir";
    public static final String ZK_STR = "controller.zk.str";
    public static final String UPDATE_SEGMENT_STATE_MODEL = "controller.update_segment_state_model";
    public static final String HELIX_CLUSTER_NAME = "controller.helix.cluster.name";
    public static final String CLUSTER_TENANT_ISOLATION_ENABLE = "cluster.tenant.isolation.enable";
    public static final String CONSOLE_WEBAPP_ROOT_PATH = "controller.query.console";
    public static final String CONTROLLER_MODE = "controller.mode";
    public static final String LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = "controller.resource.rebalance.strategy";
    public static final String TABLE_CONFIG_TUNER_PACKAGES = "controller.table.config.tuner.packages";
    public static final String DEFAULT_TABLE_CONFIG_TUNER_PACKAGES = "org.apache.pinot";
    public static final String CONTROLLER_RESOURCE_PACKAGES = "controller.restlet.api.resource.packages";
    public static final String DEFAULT_CONTROLLER_RESOURCE_PACKAGES = "org.apache.pinot.controller.api.resources";
    private static final String SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = "server.request.timeoutSeconds";
    private static final String SEGMENT_COMMIT_TIMEOUT_SECONDS = "controller.realtime.segment.commit.timeoutSeconds";
    private static final String DELETED_SEGMENTS_RETENTION_IN_DAYS = "controller.deleted.segments.retentionInDays";
    public static final String TABLE_MIN_REPLICAS = "table.minReplicas";
    public static final String ENABLE_SPLIT_COMMIT = "controller.enable.split.commit";
    private static final String JERSEY_ADMIN_API_PORT = "jersey.admin.api.port";
    private static final String JERSEY_ADMIN_IS_PRIMARY = "jersey.admin.isprimary";
    public static final String ACCESS_CONTROL_FACTORY_CLASS = "controller.admin.access.control.factory.class";
    private static final String SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = "controller.segment.upload.timeoutInMillis";
    private static final String REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = "controller.realtime.segment.metadata.commit.numLocks";
    private static final String ENABLE_STORAGE_QUOTA_CHECK = "controller.enable.storage.quota.check";
    private static final String ENABLE_BATCH_MESSAGE_MODE = "controller.enable.batch.message.mode";
    public static final String ALLOW_HLC_TABLES = "controller.allow.hlc.tables";
    public static final String DIM_TABLE_MAX_SIZE = "controller.dimTable.maxSize";
    private static final String PINOT_FS_FACTORY_CLASS_LOCAL = "controller.storage.factory.class.file";
    private static final int DEFAULT_SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_DELETED_SEGMENTS_RETENTION_IN_DAYS = 7;
    private static final int DEFAULT_TABLE_MIN_REPLICAS = 1;
    private static final boolean DEFAULT_ENABLE_SPLIT_COMMIT = false;
    private static final int DEFAULT_JERSEY_ADMIN_PORT = 21000;
    private static final String DEFAULT_ACCESS_CONTROL_FACTORY_CLASS = "org.apache.pinot.controller.api.access.AllowAllAccessFactory";
    private static final long DEFAULT_SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = 600000L;
    private static final int DEFAULT_REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = 64;
    private static final boolean DEFAULT_ENABLE_STORAGE_QUOTA_CHECK = true;
    private static final boolean DEFAULT_ENABLE_BATCH_MESSAGE_MODE = false;
    private static final boolean DEFAULT_ALLOW_HLC_TABLES = true;
    private static final String DEFAULT_CONTROLLER_MODE = ControllerMode.DUAL.name();
    private static final String DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = AutoRebalanceStrategy.class.getName();
    private static final String DEFAULT_DIM_TABLE_MAX_SIZE = "200M";
    private static final String DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL = LocalPinotFS.class.getName();

    public ControllerConf() {
        super(new HashMap());
    }

    public ControllerConf(Map<String, Object> baseProperties) {
        super(baseProperties);
    }

    public ControllerConf(Configuration baseConfiguration) {
        super(baseConfiguration);
    }

    public void setLocalTempDir(String localTempDir) {
        this.setProperty(LOCAL_TEMP_DIR, localTempDir);
    }

    public String getLocalTempDir() {
        return this.getProperty(LOCAL_TEMP_DIR);
    }

    public void setPinotFSFactoryClasses(Configuration pinotFSFactoryClasses) {
        this.setProperty(PINOT_FS_FACTORY_CLASS_LOCAL, DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL);
        if (pinotFSFactoryClasses != null) {
            pinotFSFactoryClasses.getKeys().forEachRemaining(key -> this.setProperty((String)key, pinotFSFactoryClasses.getProperty(key)));
        }
    }

    public void setSplitCommit(boolean isSplitCommit) {
        this.setProperty(ENABLE_SPLIT_COMMIT, isSplitCommit);
    }

    public void setQueryConsolePath(String path) {
        this.setProperty(CONSOLE_WEBAPP_ROOT_PATH, path);
    }

    public String getQueryConsoleWebappPath() {
        return Optional.ofNullable(this.getProperty(CONSOLE_WEBAPP_ROOT_PATH)).orElseGet(() -> ControllerConf.class.getClassLoader().getResource("webapp").toExternalForm());
    }

    public void setJerseyAdminPrimary(String jerseyAdminPrimary) {
        this.setProperty(JERSEY_ADMIN_IS_PRIMARY, jerseyAdminPrimary);
    }

    public void setHelixClusterName(String clusterName) {
        this.setProperty("pinot.cluster.name", clusterName);
    }

    public void setControllerHost(String host) {
        this.setProperty(CONTROLLER_HOST, host);
    }

    public void setControllerVipHost(String vipHost) {
        this.setProperty(CONTROLLER_VIP_HOST, vipHost);
    }

    public void setControllerVipPort(String vipPort) {
        this.setProperty(CONTROLLER_VIP_PORT, vipPort);
    }

    public void setControllerVipProtocol(String vipProtocol) {
        this.setProperty(CONTROLLER_VIP_PROTOCOL, vipProtocol);
    }

    public void setControllerBrokerProtocol(String protocol) {
        this.setProperty(CONTROLLER_BROKER_PROTOCOL, protocol);
    }

    public void setControllerPort(String port) {
        this.setProperty(CONTROLLER_PORT, port);
    }

    public void setDataDir(String dataDir) {
        this.setProperty(DATA_DIR, dataDir);
    }

    public void setRealtimeSegmentCommitTimeoutSeconds(int timeoutSec) {
        this.setProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS, Integer.toString(timeoutSec));
    }

    public void setUpdateSegmentStateModel(String updateStateModel) {
        this.setProperty(UPDATE_SEGMENT_STATE_MODEL, updateStateModel);
    }

    public void setZkStr(String zkStr) {
        this.setProperty("pinot.zk.server", zkStr);
    }

    public void setDimTableMaxSize(String size) {
        this.setProperty(DIM_TABLE_MAX_SIZE, size);
    }

    public String getDimTableMaxSize() {
        return this.getProperty(DIM_TABLE_MAX_SIZE, DEFAULT_DIM_TABLE_MAX_SIZE);
    }

    public boolean isJerseyAdminPrimary() {
        return this.getProperty(JERSEY_ADMIN_IS_PRIMARY, true);
    }

    public String getHelixClusterName() {
        return this.containsKey("pinot.cluster.name") ? this.getProperty("pinot.cluster.name") : this.getProperty(HELIX_CLUSTER_NAME);
    }

    public String getControllerHost() {
        return this.getProperty(CONTROLLER_HOST);
    }

    public String getControllerPort() {
        return this.getProperty(CONTROLLER_PORT);
    }

    public String getInstanceId() {
        return this.getProperty("pinot.controller.instance.id");
    }

    public List<String> getControllerAccessProtocols() {
        return this.getProperty(CONTROLLER_ACCESS_PROTOCOLS, this.getControllerPort() == null ? Arrays.asList("http") : Arrays.asList(new String[0]));
    }

    public String getControllerAccessProtocolProperty(String protocol, String property) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property);
    }

    public String getControllerAccessProtocolProperty(String protocol, String property, String defaultValue) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property, defaultValue);
    }

    public boolean getControllerAccessProtocolProperty(String protocol, String property, boolean defaultValue) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property, defaultValue);
    }

    public String getDataDir() {
        return this.getProperty(DATA_DIR);
    }

    public int getSegmentCommitTimeoutSeconds() {
        return this.getProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS, SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds());
    }

    public boolean isUpdateSegmentStateModel() {
        return this.getProperty(UPDATE_SEGMENT_STATE_MODEL, false);
    }

    public String generateVipUrl() {
        return this.getControllerVipProtocol() + "://" + this.getControllerVipHost() + ":" + this.getControllerVipPort();
    }

    public String getZkStr() {
        String zkAddressObj;
        String string = zkAddressObj = this.containsKey("pinot.zk.server") ? this.getProperty("pinot.zk.server") : this.getProperty(ZK_STR);
        if (zkAddressObj instanceof List) {
            List zkAddressList = (List)((Object)zkAddressObj);
            String[] zkAddress = zkAddressList.toArray(new String[0]);
            return StringUtil.join((String)",", (String[])zkAddress);
        }
        if (zkAddressObj instanceof String) {
            return zkAddressObj;
        }
        throw new RuntimeException("Unexpected data type for zkAddress PropertiesConfiguration, expecting String but got " + zkAddressObj.getClass().getName());
    }

    public String toString() {
        return super.toString();
    }

    public boolean getAcceptSplitCommit() {
        return this.getProperty(ENABLE_SPLIT_COMMIT, false);
    }

    public String getControllerVipHost() {
        return Optional.ofNullable(this.getProperty(CONTROLLER_VIP_HOST)).filter(controllerVipHost -> !controllerVipHost.isEmpty()).orElseGet(() -> this.getProperty(CONTROLLER_HOST));
    }

    public String getControllerVipPort() {
        return Optional.ofNullable(this.getProperty(CONTROLLER_VIP_PORT)).filter(controllerVipPort -> !controllerVipPort.isEmpty()).orElseGet(() -> this.getControllerAccessProtocols().stream().filter(protocol -> this.getControllerAccessProtocolProperty((String)protocol, "vip", false)).map(protocol -> Optional.ofNullable(this.getControllerAccessProtocolProperty((String)protocol, "port"))).filter(Optional::isPresent).map(Optional::get).findFirst().orElseGet(this::getControllerPort));
    }

    public String getControllerVipProtocol() {
        return this.getSupportedProtocol(CONTROLLER_VIP_PROTOCOL);
    }

    public String getControllerBrokerProtocol() {
        return this.getSupportedProtocol(CONTROLLER_BROKER_PROTOCOL);
    }

    public int getRetentionControllerFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.retention.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.retention.frequencyInSeconds", 21600));
    }

    public void setRetentionControllerFrequencyInSeconds(int retentionFrequencyInSeconds) {
        this.setProperty("controller.retention.frequencyInSeconds", Integer.toString(retentionFrequencyInSeconds));
    }

    public int getOfflineSegmentIntervalCheckerFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.offline.segment.interval.checker.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.offline.segment.interval.checker.frequencyInSeconds", 86400));
    }

    public void setOfflineSegmentIntervalCheckerFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.offline.segment.interval.checker.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getRealtimeSegmentValidationFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.realtime.segment.validation.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.realtime.segment.validation.frequencyInSeconds", 3600));
    }

    public void setRealtimeSegmentValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.realtime.segment.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getBrokerResourceValidationFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.broker.resource.validation.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.broker.resource.validation.frequencyInSeconds", 3600));
    }

    public void setBrokerResourceValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.broker.resource.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public long getBrokerResourceValidationInitialDelayInSeconds() {
        return this.getProperty("controller.broker.resource.validation.initialDelayInSeconds", this.getPeriodicTaskInitialDelayInSeconds());
    }

    public int getStatusCheckerFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.statuschecker.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.statuschecker.frequencyInSeconds", 300));
    }

    public void setStatusCheckerFrequencyInSeconds(int statusCheckerFrequencyInSeconds) {
        this.setProperty("controller.statuschecker.frequencyInSeconds", Integer.toString(statusCheckerFrequencyInSeconds));
    }

    public int getTaskMetricsEmitterFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.minion.task.metrics.emitter.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.minion.task.metrics.emitter.frequencyInSeconds", 300));
    }

    public void setTaskMetricsEmitterFrequencyInSeconds(int taskMetricsEmitterFrequencyInSeconds) {
        this.setProperty("controller.minion.task.metrics.emitter.frequencyInSeconds", Integer.toString(taskMetricsEmitterFrequencyInSeconds));
    }

    public int getStatusCheckerWaitForPushTimeInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.statuschecker.waitForPushTimePeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.statuschecker.waitForPushTimeInSeconds", 600));
    }

    public void setStatusCheckerWaitForPushTimeInSeconds(int statusCheckerWaitForPushTimeInSeconds) {
        this.setProperty("controller.statuschecker.waitForPushTimeInSeconds", Integer.toString(statusCheckerWaitForPushTimeInSeconds));
    }

    public int getSegmentRelocatorFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.segment.relocator.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> {
            Integer segmentRelocatorFreqSeconds = (Integer)this.getProperty("controller.segment.relocator.frequencyInSeconds", Integer.class);
            if (segmentRelocatorFreqSeconds == null) {
                String realtimeSegmentRelocatorPeriod = this.getProperty("controller.realtime.segment.relocator.frequency");
                segmentRelocatorFreqSeconds = realtimeSegmentRelocatorPeriod != null ? Integer.valueOf((int)this.convertPeriodToSeconds(realtimeSegmentRelocatorPeriod)) : Integer.valueOf(3600);
            }
            return segmentRelocatorFreqSeconds;
        });
    }

    public void setSegmentRelocatorFrequencyInSeconds(int segmentRelocatorFrequencyInSeconds) {
        this.setProperty("controller.segment.relocator.frequencyInSeconds", Integer.toString(segmentRelocatorFrequencyInSeconds));
    }

    public boolean tenantIsolationEnabled() {
        return this.getProperty(CLUSTER_TENANT_ISOLATION_ENABLE, true);
    }

    public void setTenantIsolationEnabled(boolean isSingleTenant) {
        this.setProperty(CLUSTER_TENANT_ISOLATION_ENABLE, isSingleTenant);
    }

    public void setServerAdminRequestTimeoutSeconds(int timeoutSeconds) {
        this.setProperty(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, timeoutSeconds);
    }

    public int getServerAdminRequestTimeoutSeconds() {
        return this.getProperty(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, 30);
    }

    public int getDeletedSegmentsRetentionInDays() {
        return this.getProperty(DELETED_SEGMENTS_RETENTION_IN_DAYS, 7);
    }

    public void setDeletedSegmentsRetentionInDays(int retentionInDays) {
        this.setProperty(DELETED_SEGMENTS_RETENTION_IN_DAYS, retentionInDays);
    }

    public int getTaskManagerFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.task.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.task.frequencyInSeconds", -1));
    }

    public void setTaskManagerFrequencyInSeconds(int frequencyInSeconds) {
        this.setProperty("controller.task.frequencyInSeconds", Integer.toString(frequencyInSeconds));
    }

    public int getMinionInstancesCleanupTaskFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.minion.instances.cleanup.task.frequencyPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.minion.instances.cleanup.task.frequencyInSeconds", 3600));
    }

    public void setMinionInstancesCleanupTaskFrequencyInSeconds(int frequencyInSeconds) {
        this.setProperty("controller.minion.instances.cleanup.task.frequencyInSeconds", Integer.toString(frequencyInSeconds));
    }

    public long getMinionInstancesCleanupTaskInitialDelaySeconds() {
        return this.getProperty("controller.minion.instances.cleanup.task.initialDelaySeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public void setMinionInstancesCleanupTaskInitialDelaySeconds(int initialDelaySeconds) {
        this.setProperty("controller.minion.instances.cleanup.task.initialDelaySeconds", Integer.toString(initialDelaySeconds));
    }

    public int getMinionInstancesCleanupTaskMinOfflineTimeBeforeDeletionInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.minion.instances.cleanup.task.minOfflineTimeBeforeDeletionPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.minion.instances.cleanup.task.minOfflineTimeBeforeDeletionSeconds", 3600));
    }

    public void setMinionInstancesCleanupTaskMinOfflineTimeBeforeDeletionInSeconds(int maxOfflineTimeRangeInSeconds) {
        this.setProperty("controller.minion.instances.cleanup.task.minOfflineTimeBeforeDeletionSeconds", Integer.toString(maxOfflineTimeRangeInSeconds));
    }

    public int getDefaultTableMinReplicas() {
        return this.getProperty(TABLE_MIN_REPLICAS, 1);
    }

    public void setTableMinReplicas(int minReplicas) {
        this.setProperty(TABLE_MIN_REPLICAS, minReplicas);
    }

    public String getJerseyAdminApiPort() {
        return this.getProperty(JERSEY_ADMIN_API_PORT, String.valueOf(21000));
    }

    public String getAccessControlFactoryClass() {
        return this.getProperty(ACCESS_CONTROL_FACTORY_CLASS, DEFAULT_ACCESS_CONTROL_FACTORY_CLASS);
    }

    public void setAccessControlFactoryClass(String accessControlFactoryClass) {
        this.setProperty(ACCESS_CONTROL_FACTORY_CLASS, accessControlFactoryClass);
    }

    public long getSegmentUploadTimeoutInMillis() {
        return this.getProperty(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, 600000L);
    }

    public void setSegmentUploadTimeoutInMillis(long segmentUploadTimeoutInMillis) {
        this.setProperty(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, segmentUploadTimeoutInMillis);
    }

    public int getRealtimeSegmentMetadataCommitNumLocks() {
        return this.getProperty(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, 64);
    }

    public void setRealtimeSegmentMetadataCommitNumLocks(int realtimeSegmentMetadataCommitNumLocks) {
        this.setProperty(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, realtimeSegmentMetadataCommitNumLocks);
    }

    public boolean getEnableStorageQuotaCheck() {
        return this.getProperty(ENABLE_STORAGE_QUOTA_CHECK, true);
    }

    public boolean getEnableBatchMessageMode() {
        return this.getProperty(ENABLE_BATCH_MESSAGE_MODE, false);
    }

    public int getSegmentLevelValidationIntervalInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.segment.level.validation.intervalPeriod")).map(period -> (int)this.convertPeriodToSeconds((String)period)).orElseGet(() -> this.getProperty("controller.segment.level.validation.intervalInSeconds", 86400));
    }

    public long getStatusCheckerInitialDelayInSeconds() {
        return this.getProperty("controller.statusChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRetentionManagerInitialDelayInSeconds() {
        return this.getProperty("controller.retentionManager.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getOfflineSegmentIntervalCheckerInitialDelayInSeconds() {
        return this.getProperty("controller.offlineSegmentIntervalChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRealtimeSegmentValidationManagerInitialDelaySeconds() {
        return this.getProperty("controller.realtime.segment.validation.initialDelayInSeconds", this.getPeriodicTaskInitialDelayInSeconds());
    }

    public boolean isDeepStoreRetryUploadLLCSegmentEnabled() {
        return this.getProperty("controller.realtime.segment.deepStoreUploadRetryEnabled", false);
    }

    public long getPinotTaskManagerInitialDelaySeconds() {
        return this.getPeriodicTaskInitialDelayInSeconds();
    }

    public boolean isPinotTaskManagerSchedulerEnabled() {
        return this.getProperty("controller.task.scheduler.enabled", false);
    }

    public long getSegmentRelocatorInitialDelayInSeconds() {
        Long segmentRelocatorInitialDelaySeconds = (Long)this.getProperty("controller.segmentRelocator.initialDelayInSeconds", Long.class);
        if (segmentRelocatorInitialDelaySeconds == null) {
            segmentRelocatorInitialDelaySeconds = this.getProperty("controller.realtimeSegmentRelocation.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
        }
        return segmentRelocatorInitialDelaySeconds;
    }

    public long getPeriodicTaskInitialDelayInSeconds() {
        return ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.setProperty(CONTROLLER_MODE, controllerMode.name());
    }

    public ControllerMode getControllerMode() {
        return ControllerMode.valueOf(this.getProperty(CONTROLLER_MODE, DEFAULT_CONTROLLER_MODE.toString()).toUpperCase());
    }

    public void setLeadControllerResourceRebalanceStrategy(String rebalanceStrategy) {
        this.setProperty(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, rebalanceStrategy);
    }

    public String getLeadControllerResourceRebalanceStrategy() {
        return this.getProperty(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY);
    }

    public boolean getHLCTablesAllowed() {
        return this.getProperty(ALLOW_HLC_TABLES, true);
    }

    public void setHLCTablesAllowed(boolean allowHLCTables) {
        this.setProperty(ALLOW_HLC_TABLES, allowHLCTables);
    }

    public String getMetricsPrefix() {
        return this.getProperty("controller.metrics.prefix", "pinot.controller.");
    }

    public int getControllerBrokerPortOverride() {
        return this.getProperty(CONTROLLER_BROKER_PORT_OVERRIDE, -1);
    }

    public List<String> getTableConfigTunerPackages() {
        return Arrays.asList(this.getProperty(TABLE_CONFIG_TUNER_PACKAGES, DEFAULT_TABLE_CONFIG_TUNER_PACKAGES).split("\\s*,\\s*"));
    }

    public String getControllerResourcePackages() {
        return this.getProperty(CONTROLLER_RESOURCE_PACKAGES, DEFAULT_CONTROLLER_RESOURCE_PACKAGES);
    }

    private long convertPeriodToUnit(String period, TimeUnit timeUnitToConvertTo) {
        return timeUnitToConvertTo.convert(TimeUtils.convertPeriodToMillis((String)period), TimeUnit.MILLISECONDS);
    }

    private long convertPeriodToSeconds(String period) {
        return this.convertPeriodToUnit(period, TimeUnit.SECONDS);
    }

    private String getSupportedProtocol(String property) {
        String value = this.getProperty(property, "http");
        Preconditions.checkArgument((boolean)SUPPORTED_PROTOCOLS.contains(value), (String)"Unsupported %s protocol '%s'", (Object)property, (Object)value);
        return value;
    }

    public static class ControllerPeriodicTasksConf {
        @Deprecated
        public static final String DEPRECATED_RETENTION_MANAGER_FREQUENCY_IN_SECONDS = "controller.retention.frequencyInSeconds";
        public static final String RETENTION_MANAGER_FREQUENCY_PERIOD = "controller.retention.frequencyPeriod";
        @Deprecated
        public static final String DEPRECATED_OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = "controller.offline.segment.interval.checker.frequencyInSeconds";
        public static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_PERIOD = "controller.offline.segment.interval.checker.frequencyPeriod";
        @Deprecated
        public static final String DEPRECATED_REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = "controller.realtime.segment.validation.frequencyInSeconds";
        public static final String REALTIME_SEGMENT_VALIDATION_FREQUENCY_PERIOD = "controller.realtime.segment.validation.frequencyPeriod";
        public static final String REALTIME_SEGMENT_VALIDATION_INITIAL_DELAY_IN_SECONDS = "controller.realtime.segment.validation.initialDelayInSeconds";
        @Deprecated
        public static final String DEPRECATED_BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = "controller.broker.resource.validation.frequencyInSeconds";
        public static final String BROKER_RESOURCE_VALIDATION_FREQUENCY_PERIOD = "controller.broker.resource.validation.frequencyPeriod";
        public static final String BROKER_RESOURCE_VALIDATION_INITIAL_DELAY_IN_SECONDS = "controller.broker.resource.validation.initialDelayInSeconds";
        @Deprecated
        public static final String DEPRECATED_STATUS_CHECKER_FREQUENCY_IN_SECONDS = "controller.statuschecker.frequencyInSeconds";
        public static final String STATUS_CHECKER_FREQUENCY_PERIOD = "controller.statuschecker.frequencyPeriod";
        @Deprecated
        public static final String DEPRECATED_STATUS_CHECKER_WAIT_FOR_PUSH_TIME_IN_SECONDS = "controller.statuschecker.waitForPushTimeInSeconds";
        public static final String STATUS_CHECKER_WAIT_FOR_PUSH_TIME_PERIOD = "controller.statuschecker.waitForPushTimePeriod";
        @Deprecated
        public static final String DEPRECATED_TASK_MANAGER_FREQUENCY_IN_SECONDS = "controller.task.frequencyInSeconds";
        public static final String TASK_MANAGER_FREQUENCY_PERIOD = "controller.task.frequencyPeriod";
        @Deprecated
        public static final String DEPRECATED_MINION_INSTANCES_CLEANUP_TASK_FREQUENCY_IN_SECONDS = "controller.minion.instances.cleanup.task.frequencyInSeconds";
        public static final String MINION_INSTANCES_CLEANUP_TASK_FREQUENCY_PERIOD = "controller.minion.instances.cleanup.task.frequencyPeriod";
        public static final String MINION_INSTANCES_CLEANUP_TASK_INITIAL_DELAY_SECONDS = "controller.minion.instances.cleanup.task.initialDelaySeconds";
        @Deprecated
        public static final String DEPRECATED_MINION_INSTANCES_CLEANUP_TASK_MIN_OFFLINE_TIME_BEFORE_DELETION_SECONDS = "controller.minion.instances.cleanup.task.minOfflineTimeBeforeDeletionSeconds";
        public static final String MINION_INSTANCES_CLEANUP_TASK_MIN_OFFLINE_TIME_BEFORE_DELETION_PERIOD = "controller.minion.instances.cleanup.task.minOfflineTimeBeforeDeletionPeriod";
        @Deprecated
        public static final String DEPRECATED_TASK_METRICS_EMITTER_FREQUENCY_IN_SECONDS = "controller.minion.task.metrics.emitter.frequencyInSeconds";
        public static final String TASK_METRICS_EMITTER_FREQUENCY_PERIOD = "controller.minion.task.metrics.emitter.frequencyPeriod";
        public static final String PINOT_TASK_MANAGER_SCHEDULER_ENABLED = "controller.task.scheduler.enabled";
        @Deprecated
        public static final String DEPRECATED_REALTIME_SEGMENT_RELOCATOR_FREQUENCY = "controller.realtime.segment.relocator.frequency";
        @Deprecated
        public static final String DEPRECATED_SEGMENT_RELOCATOR_FREQUENCY_IN_SECONDS = "controller.segment.relocator.frequencyInSeconds";
        public static final String SEGMENT_RELOCATOR_FREQUENCY_PERIOD = "controller.segment.relocator.frequencyPeriod";
        @Deprecated
        public static final String DEPRECATED_SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = "controller.segment.level.validation.intervalInSeconds";
        public static final String SEGMENT_LEVEL_VALIDATION_INTERVAL_PERIOD = "controller.segment.level.validation.intervalPeriod";
        public static final String STATUS_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.statusChecker.initialDelayInSeconds";
        public static final String RETENTION_MANAGER_INITIAL_DELAY_IN_SECONDS = "controller.retentionManager.initialDelayInSeconds";
        public static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.offlineSegmentIntervalChecker.initialDelayInSeconds";
        @Deprecated
        public static final String DEPRECATED_REALTIME_SEGMENT_RELOCATION_INITIAL_DELAY_IN_SECONDS = "controller.realtimeSegmentRelocation.initialDelayInSeconds";
        public static final String SEGMENT_RELOCATOR_INITIAL_DELAY_IN_SECONDS = "controller.segmentRelocator.initialDelayInSeconds";
        public static final String ENABLE_DEEP_STORE_RETRY_UPLOAD_LLC_SEGMENT = "controller.realtime.segment.deepStoreUploadRetryEnabled";
        public static final int MIN_INITIAL_DELAY_IN_SECONDS = 120;
        public static final int MAX_INITIAL_DELAY_IN_SECONDS = 300;
        private static final Random RANDOM = new Random();
        private static final int DEFAULT_RETENTION_MANAGER_FREQUENCY_IN_SECONDS = 21600;
        private static final int DEFAULT_OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = 86400;
        private static final int DEFAULT_REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_STATUS_CONTROLLER_FREQUENCY_IN_SECONDS = 300;
        private static final int DEFAULT_TASK_METRICS_EMITTER_FREQUENCY_IN_SECONDS = 300;
        private static final int DEFAULT_STATUS_CONTROLLER_WAIT_FOR_PUSH_TIME_IN_SECONDS = 600;
        private static final int DEFAULT_TASK_MANAGER_FREQUENCY_IN_SECONDS = -1;
        private static final int DEFAULT_MINION_INSTANCES_CLEANUP_TASK_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_MINION_INSTANCES_CLEANUP_TASK_MIN_OFFLINE_TIME_BEFORE_DELETION_IN_SECONDS = 3600;
        private static final int DEFAULT_SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = 86400;
        private static final int DEFAULT_SEGMENT_RELOCATOR_FREQUENCY_IN_SECONDS = 3600;

        private static long getRandomInitialDelayInSeconds() {
            return 120 + RANDOM.nextInt(180);
        }
    }

    public static enum ControllerMode {
        DUAL,
        PINOT_ONLY,
        HELIX_ONLY;

    }
}

