/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import java.util.Optional;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessControlUtils.class);

    public void validatePermission(String tableName, AccessType accessType, HttpHeaders httpHeaders, String endpointUrl, AccessControl accessControl) {
        this.validatePermission(Optional.of(tableName), accessType, httpHeaders, endpointUrl, accessControl);
    }

    public void validatePermission(AccessType accessType, HttpHeaders httpHeaders, String endpointUrl, AccessControl accessControl) {
        this.validatePermission(Optional.empty(), accessType, httpHeaders, endpointUrl, accessControl);
    }

    public void validatePermission(Optional<String> tableNameOpt, AccessType accessType, HttpHeaders httpHeaders, String endpointUrl, AccessControl accessControl) {
        boolean hasPermission;
        String accessTypeToEndpointMsg = String.format("access type '%s' to the endpoint '%s'", new Object[]{accessType, endpointUrl}) + tableNameOpt.map(name -> String.format(" for table '%s'", name)).orElse("");
        try {
            if (tableNameOpt.isPresent()) {
                String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameOpt.get());
                hasPermission = accessControl.hasAccess(rawTableName, accessType, httpHeaders, endpointUrl);
            } else {
                hasPermission = accessControl.hasAccess(accessType, httpHeaders, endpointUrl);
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught exception while validating permission for " + accessTypeToEndpointMsg, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (!hasPermission) {
            throw new ControllerApplicationException(LOGGER, "Permission is denied for " + accessTypeToEndpointMsg, Response.Status.FORBIDDEN);
        }
    }
}

