/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.HttpHeaders;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.core.auth.BasicAuthPrincipal;
import org.apache.pinot.core.auth.BasicAuthUtils;
import org.apache.pinot.spi.env.PinotConfiguration;

public class BasicAuthAccessControlFactory
implements AccessControlFactory {
    private static final String PREFIX = "controller.admin.access.control.principals";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private AccessControl _accessControl;

    @Override
    public void init(PinotConfiguration configuration) {
        this._accessControl = new BasicAuthAccessControl(BasicAuthUtils.extractBasicAuthPrincipals((PinotConfiguration)configuration, (String)PREFIX));
    }

    @Override
    public AccessControl create() {
        return this._accessControl;
    }

    private static class BasicAuthAccessControl
    implements AccessControl {
        private final Map<String, BasicAuthPrincipal> _token2principal;

        public BasicAuthAccessControl(Collection<BasicAuthPrincipal> principals) {
            this._token2principal = principals.stream().collect(Collectors.toMap(BasicAuthPrincipal::getToken, p -> p));
        }

        @Override
        public boolean protectAnnotatedOnly() {
            return false;
        }

        @Override
        public boolean hasDataAccess(HttpHeaders httpHeaders, String tableName) {
            return this.getPrincipal(httpHeaders).filter(p -> p.hasTable(tableName)).isPresent();
        }

        @Override
        public boolean hasAccess(String tableName, AccessType accessType, HttpHeaders httpHeaders, String endpointUrl) {
            return this.getPrincipal(httpHeaders).filter(p -> p.hasTable(tableName) && p.hasPermission(Objects.toString((Object)accessType))).isPresent();
        }

        @Override
        public boolean hasAccess(AccessType accessType, HttpHeaders httpHeaders, String endpointUrl) {
            return this.getPrincipal(httpHeaders).isPresent();
        }

        private Optional<BasicAuthPrincipal> getPrincipal(HttpHeaders headers) {
            if (headers == null) {
                return Optional.empty();
            }
            List authHeaders = headers.getRequestHeader(BasicAuthAccessControlFactory.HEADER_AUTHORIZATION);
            if (authHeaders == null) {
                return Optional.empty();
            }
            return authHeaders.stream().map(BasicAuthUtils::normalizeBase64Token).map(this._token2principal::get).filter(Objects::nonNull).findFirst();
        }

        @Override
        public AccessControl.AuthWorkflowInfo getAuthWorkflowInfo() {
            return new AccessControl.AuthWorkflowInfo("BASIC");
        }
    }
}

