/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.Criteria;
import org.apache.helix.InstanceType;
import org.apache.helix.model.Message;
import org.apache.pinot.common.messages.RunPeriodicTaskMessage;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.periodictask.PeriodicTaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"PeriodicTask"})
@Path(value="/periodictask")
public class PinotControllerPeriodicTaskRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotControllerPeriodicTaskRestletResource.class);
    private static final String API_REQUEST_ID_PREFIX = "api-";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    PeriodicTaskScheduler _periodicTaskScheduler;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/run")
    @ApiOperation(value="Run periodic task against table. If table name is missing, task will run against all tables.")
    public String runPeriodicTask(@ApiParam(value="Periodic task name", required=true) @QueryParam(value="taskname") String periodicTaskName, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="OFFLINE | REALTIME") @QueryParam(value="type") String tableType) {
        if (!this._periodicTaskScheduler.hasTask(periodicTaskName)) {
            throw new WebApplicationException("Periodic task '" + periodicTaskName + "' not found.", Response.Status.NOT_FOUND);
        }
        if (tableName != null) {
            List<String> matchingTableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName = tableName.trim(), Constants.validateTableType(tableType), LOGGER);
            if (matchingTableNamesWithType.size() > 1) {
                throw new WebApplicationException("More than one table matches Table '" + tableName + "'. Matching names: " + matchingTableNamesWithType.toString());
            }
            tableName = matchingTableNamesWithType.get(0);
        }
        String periodicTaskRequestId = API_REQUEST_ID_PREFIX + UUID.randomUUID().toString().substring(0, 8);
        LOGGER.info("[TaskRequestId: {}] Sending periodic task message to all controllers for running task {} against {}.", new Object[]{periodicTaskRequestId, periodicTaskName, tableName != null ? " table '" + tableName + "'" : "all tables"});
        Criteria recipientCriteria = new Criteria();
        recipientCriteria.setRecipientInstanceType(InstanceType.PARTICIPANT);
        recipientCriteria.setInstanceName("%");
        recipientCriteria.setSessionSpecific(true);
        recipientCriteria.setResource("leadControllerResource");
        recipientCriteria.setSelfExcluded(false);
        RunPeriodicTaskMessage runPeriodicTaskMessage = new RunPeriodicTaskMessage(periodicTaskRequestId, periodicTaskName, tableName);
        ClusterMessagingService clusterMessagingService = this._pinotHelixResourceManager.getHelixZkManager().getMessagingService();
        int messageCount = clusterMessagingService.send(recipientCriteria, (Message)runPeriodicTaskMessage, null, -1);
        LOGGER.info("[TaskRequestId: {}] Periodic task execution message sent to {} controllers.", (Object)periodicTaskRequestId, (Object)messageCount);
        return "{\"Log Request Id\": \"" + periodicTaskRequestId + "\",\"Controllers notified\":" + (messageCount > 0) + "}";
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/names")
    @ApiOperation(value="Get comma-delimited list of all available periodic task names.")
    public List<String> getPeriodicTaskNames() {
        return this._periodicTaskScheduler.getTaskNames();
    }
}

