/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.lineage.SegmentLineageAccessHelper;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.common.minion.MinionTaskMetadataUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class ClusterInfoAccessor {
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    private final ControllerConf _controllerConf;
    private final ControllerMetrics _controllerMetrics;
    private final LeadControllerManager _leadControllerManager;

    public ClusterInfoAccessor(PinotHelixResourceManager pinotHelixResourceManager, PinotHelixTaskResourceManager pinotHelixTaskResourceManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics, LeadControllerManager leadControllerManager) {
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._pinotHelixTaskResourceManager = pinotHelixTaskResourceManager;
        this._controllerConf = controllerConf;
        this._controllerMetrics = controllerMetrics;
        this._leadControllerManager = leadControllerManager;
    }

    @Nullable
    public TableConfig getTableConfig(String tableNameWithType) {
        return this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
    }

    @Nullable
    public Schema getTableSchema(String tableName) {
        return this._pinotHelixResourceManager.getTableSchema(tableName);
    }

    public List<SegmentZKMetadata> getSegmentsZKMetadata(String tableNameWithType) {
        return ZKMetadataProvider.getSegmentsZKMetadata(this._pinotHelixResourceManager.getPropertyStore(), (String)tableNameWithType);
    }

    public ZNRecord getMinionTaskMetadataZNRecord(String taskType, String tableNameWithType) {
        return MinionTaskMetadataUtils.fetchTaskMetadata(this._pinotHelixResourceManager.getPropertyStore(), (String)taskType, (String)tableNameWithType);
    }

    @Nullable
    public SegmentLineage getSegmentLineage(String tableNameWithType) {
        return SegmentLineageAccessHelper.getSegmentLineage(this._pinotHelixResourceManager.getPropertyStore(), (String)tableNameWithType);
    }

    public void setMinionTaskMetadata(BaseTaskMetadata taskMetadata, String taskType, int expectedVersion) {
        MinionTaskMetadataUtils.persistTaskMetadata(this._pinotHelixResourceManager.getPropertyStore(), (String)taskType, (BaseTaskMetadata)taskMetadata, (int)expectedVersion);
    }

    public Map<String, TaskState> getTaskStates(String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    public List<PinotTaskConfig> getTaskConfigs(String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    public String getVipUrl() {
        return this._controllerConf.generateVipUrl();
    }

    public String getClusterConfig(String configName) {
        HelixConfigScope helixConfigScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this._pinotHelixResourceManager.getHelixClusterName()).build();
        Map configMap = this._pinotHelixResourceManager.getHelixAdmin().getConfig(helixConfigScope, Collections.singletonList(configName));
        return configMap != null ? (String)configMap.get(configName) : null;
    }

    public ControllerMetrics getControllerMetrics() {
        return this._controllerMetrics;
    }

    public LeadControllerManager getLeaderControllerManager() {
        return this._leadControllerManager;
    }

    public PinotHelixResourceManager getPinotHelixResourceManager() {
        return this._pinotHelixResourceManager;
    }

    public PinotHelixTaskResourceManager getPinotHelixTaskResourceManager() {
        return this._pinotHelixTaskResourceManager;
    }
}

