/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMetricsEmitter
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMetricsEmitter.class);
    private static final String TASK_NAME = "TaskMetricsEmitter";
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final PinotHelixTaskResourceManager _helixTaskResourceManager;
    private final ControllerMetrics _controllerMetrics;
    private final LeadControllerManager _leadControllerManager;

    public TaskMetricsEmitter(PinotHelixResourceManager pinotHelixResourceManager, PinotHelixTaskResourceManager helixTaskResourceManager, LeadControllerManager leadControllerManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        super(TASK_NAME, (long)controllerConf.getTaskMetricsEmitterFrequencyInSeconds(), controllerConf.getPeriodicTaskInitialDelayInSeconds());
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._helixTaskResourceManager = helixTaskResourceManager;
        this._controllerMetrics = controllerMetrics;
        this._leadControllerManager = leadControllerManager;
    }

    protected final void runTask(Properties periodicTaskProperties) {
        if (!this._leadControllerManager.isLeaderForTable(TASK_NAME)) {
            return;
        }
        Set<String> taskTypes = this._helixTaskResourceManager.getTaskTypes();
        for (String taskType : taskTypes) {
            PinotHelixTaskResourceManager.TaskCount accumulated = new PinotHelixTaskResourceManager.TaskCount();
            try {
                Set<String> tasksInProgress = this._helixTaskResourceManager.getTasksInProgress(taskType);
                int numRunningTasks = tasksInProgress.size();
                for (String task : tasksInProgress) {
                    PinotHelixTaskResourceManager.TaskCount taskCount = this._helixTaskResourceManager.getTaskCount(task);
                    accumulated.accumulate(taskCount);
                }
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_TASKS_IN_PROGRESS, taskType, (long)numRunningTasks);
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_RUNNING, taskType, (long)accumulated.getRunning());
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_WAITING, taskType, (long)accumulated.getWaiting());
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.NUM_MINION_SUBTASKS_ERROR, taskType, (long)accumulated.getError());
                int total = accumulated.getTotal();
                int percent = total != 0 ? (accumulated.getWaiting() + accumulated.getRunning()) * 100 / total : 0;
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_QUEUE, taskType, (long)percent);
                percent = total != 0 ? accumulated.getError() * 100 / total : 0;
                this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERCENT_MINION_SUBTASKS_IN_ERROR, taskType, (long)percent);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while getting metrics for task type {}", (Object)taskType, (Object)e);
            }
        }
        List<String> onlineInstances = this._pinotHelixResourceManager.getOnlineInstanceList();
        int onlineMinionInstanceCount = 0;
        for (String onlineInstance : onlineInstances) {
            if (!onlineInstance.startsWith("Minion_")) continue;
            ++onlineMinionInstanceCount;
        }
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.ONLINE_MINION_INSTANCES, (long)onlineMinionInstanceCount);
    }
}

