/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.periodictask;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ControllerPeriodicTask<C>
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerPeriodicTask.class);
    protected final PinotHelixResourceManager _pinotHelixResourceManager;
    protected final LeadControllerManager _leadControllerManager;
    protected final ControllerMetrics _controllerMetrics;

    public ControllerPeriodicTask(String taskName, long runFrequencyInSeconds, long initialDelayInSeconds, PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerMetrics controllerMetrics) {
        super(taskName, runFrequencyInSeconds, initialDelayInSeconds);
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._leadControllerManager = leadControllerManager;
        this._controllerMetrics = controllerMetrics;
    }

    protected final void runTask(Properties periodicTaskProperties) {
        this._controllerMetrics.addMeteredTableValue(this._taskName, (AbstractMetrics.Meter)ControllerMeter.CONTROLLER_PERIODIC_TASK_RUN, 1L);
        try {
            String propTableNameWithType = (String)periodicTaskProperties.get("tableNameWithType");
            ArrayList<String> tablesToProcess = new ArrayList<String>();
            ArrayList<String> nonLeaderForTables = new ArrayList<String>();
            if (propTableNameWithType == null) {
                for (String tableNameWithType : this._pinotHelixResourceManager.getAllTables()) {
                    if (this._leadControllerManager.isLeaderForTable(tableNameWithType)) {
                        tablesToProcess.add(tableNameWithType);
                        continue;
                    }
                    nonLeaderForTables.add(tableNameWithType);
                }
            } else if (this._leadControllerManager.isLeaderForTable(propTableNameWithType)) {
                tablesToProcess.add(propTableNameWithType);
            }
            if (!tablesToProcess.isEmpty()) {
                this.processTables(tablesToProcess);
            }
            if (!nonLeaderForTables.isEmpty()) {
                this.nonLeaderCleanup(nonLeaderForTables);
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while running task: {}", (Object)this._taskName, (Object)e);
            this._controllerMetrics.addMeteredTableValue(this._taskName, (AbstractMetrics.Meter)ControllerMeter.CONTROLLER_PERIODIC_TASK_ERROR, 1L);
        }
    }

    public final ControllerMetrics getControllerMetrics() {
        return this._controllerMetrics;
    }

    protected void processTables(List<String> tableNamesWithType) {
        int numTables = tableNamesWithType.size();
        LOGGER.info("Processing {} tables in task: {}", (Object)numTables, (Object)this._taskName);
        C context = this.preprocess();
        int numTablesProcessed = 0;
        for (String tableNameWithType : tableNamesWithType) {
            if (!this.isStarted()) {
                LOGGER.info("Task: {} is stopped, early terminate the task", (Object)this._taskName);
                break;
            }
            try {
                this.processTable(tableNameWithType, context);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while processing table: {} in task: {}", new Object[]{tableNameWithType, this._taskName, e});
            }
            ++numTablesProcessed;
        }
        this.postprocess(context);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PERIODIC_TASK_NUM_TABLES_PROCESSED, this._taskName, (long)numTablesProcessed);
        LOGGER.info("Finish processing {}/{} tables in task: {}", new Object[]{numTablesProcessed, numTables, this._taskName});
    }

    protected C preprocess() {
        return null;
    }

    protected void processTable(String tableNameWithType, C context) {
        this.processTable(tableNameWithType);
    }

    protected void processTable(String tableNameWithType) {
    }

    protected void postprocess(C context) {
        this.postprocess();
    }

    protected void postprocess() {
    }

    protected void nonLeaderCleanup(List<String> tableNamesWithType) {
    }
}

