/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.MultiValueGeneratorHelper;

public class StringGenerator
implements Generator {
    private static final double DEFAULT_NUMBER_OF_VALUES_PER_ENTRY = 1.0;
    private static final int DEFAULT_LENGTH_OF_EACH_STRING = 10;
    private final int _cardinality;
    private final Random _rand;
    private final double _numberOfValuesPerEntry;
    private final String _initialValue;
    private final int _counterLength;
    private int _counter = 0;

    public StringGenerator(Integer cardinality, Double numberOfValuesPerEntry, Integer lengthOfEachString) {
        this._cardinality = cardinality;
        this._numberOfValuesPerEntry = numberOfValuesPerEntry != null ? numberOfValuesPerEntry : 1.0;
        lengthOfEachString = lengthOfEachString != null ? lengthOfEachString : 10;
        Preconditions.checkState((this._numberOfValuesPerEntry >= 1.0 ? 1 : 0) != 0, (Object)("Number of values per entry (should be >= 1): " + this._numberOfValuesPerEntry));
        this._counterLength = String.valueOf(this._cardinality).length();
        int initValueSize = lengthOfEachString - this._counterLength;
        Preconditions.checkState((initValueSize >= 0 ? 1 : 0) != 0, (Object)String.format("Cannot generate %d unique string with length %d", this._cardinality, lengthOfEachString));
        this._initialValue = RandomStringUtils.randomAlphabetic((int)initValueSize);
        this._rand = new Random(System.currentTimeMillis());
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        if (this._numberOfValuesPerEntry == 1.0) {
            return this.getNextString();
        }
        return MultiValueGeneratorHelper.generateMultiValueEntries(this._numberOfValuesPerEntry, this._rand, this::getNextString);
    }

    private String getNextString() {
        if (this._counter == this._cardinality) {
            this._counter = 0;
        }
        ++this._counter;
        return this._initialValue + StringUtils.leftPad((String)String.valueOf(this._counter), (int)this._counterLength, (char)'0');
    }

    public static void main(String[] args) {
        StringGenerator gen = new StringGenerator(10000, null, null);
        gen.init();
        for (int i = 0; i < 1000000; ++i) {
            System.out.println(gen.next());
        }
    }
}

