/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.restlet.resources.TableMetadataInfo;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.ServerSegmentMetadataReader;
import org.apache.pinot.spi.utils.JsonUtils;

public class TableMetadataReader {
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;
    private final PinotHelixResourceManager _pinotHelixResourceManager;

    public TableMetadataReader(Executor executor, HttpConnectionManager connectionManager, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._pinotHelixResourceManager = helixResourceManager;
    }

    public JsonNode getSegmentsMetadata(String tableNameWithType, List<String> columns, int timeoutMs) throws InvalidConfigException, IOException {
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        BiMap<String, String> endpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._executor, this._connectionManager);
        List<String> segmentsMetadata = serverSegmentMetadataReader.getSegmentMetadataFromServer(tableNameWithType, serverToSegments, endpoints, columns, timeoutMs);
        HashMap<String, JsonNode> response = new HashMap<String, JsonNode>();
        for (String segmentMetadata : segmentsMetadata) {
            JsonNode responseJson = JsonUtils.stringToJsonNode((String)segmentMetadata);
            response.put(responseJson.get("segmentName").asText(), responseJson);
        }
        return JsonUtils.objectToJsonNode(response);
    }

    public JsonNode getAggregateTableMetadata(String tableNameWithType, List<String> columns, int numReplica, int timeoutMs) throws InvalidConfigException, IOException {
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        BiMap<String, String> endpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._executor, this._connectionManager);
        TableMetadataInfo aggregateTableMetadataInfo = serverSegmentMetadataReader.getAggregatedTableMetadataFromServer(tableNameWithType, endpoints, columns, numReplica, timeoutMs);
        return JsonUtils.objectToJsonNode((Object)aggregateTableMetadataInfo);
    }
}

