/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Response;

public class ExceptionHandler {
    public void handle(ServletResponse response, Exception ex) throws IOException {
        if (ex instanceof InterceptException) {
            if (response instanceof Response) {
                String errorData = ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)new ErrorData(ex.getMessage()));
                byte[] errorBytes = errorData.getBytes(StandardCharsets.UTF_8);
                int errorCode = ((InterceptException)ex).getErrorCode();
                HttpFields httpFields = new HttpFields();
                HttpField httpField = new HttpField(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
                httpFields.add(httpField);
                MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, errorCode, httpFields);
                info.setHttpVersion(HttpVersion.HTTP_1_1);
                info.setReason(errorData);
                info.setStatus(errorCode);
                info.setContentLength((long)errorBytes.length);
                ((Response)response).getHttpChannel().sendResponse(info, ByteBuffer.wrap(errorBytes), true);
            } else {
                ((HttpServletResponse)response).sendError(((InterceptException)ex).getErrorCode(), ex.getMessage());
            }
        } else {
            ((HttpServletResponse)response).sendError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage());
        }
    }
}

