/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bookies")
@Api(value="/bookies", description="Configure bookies rack placement", tags={"bookies"})
@Produces(value={"application/json"})
public class Bookies
extends AdminResource {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger log = LoggerFactory.getLogger(Bookies.class);

    @GET
    @Path(value="/racks-info")
    @ApiOperation(value="Gets the rack placement information for all the bookies in the cluster", response=BookiesRackConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookiesRackConfiguration getBookiesRackInfo() throws Exception {
        this.validateSuperUserAccess();
        return this.localZkCache().getData("/bookies", (ZooKeeperCache.Deserializer)new ZooKeeperCache.Deserializer<BookiesRackConfiguration>(){

            public BookiesRackConfiguration deserialize(String key, byte[] content) throws Exception {
                return (BookiesRackConfiguration)ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class);
            }
        }).orElse(new BookiesRackConfiguration());
    }

    @GET
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Gets the rack placement information for a specific bookie in the cluster", response=BookieInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookieInfo getBookieRackInfo(@PathParam(value="bookie") String bookieAddress) throws Exception {
        this.validateSuperUserAccess();
        BookiesRackConfiguration racks = this.localZkCache().getData("/bookies", (key, content) -> (BookiesRackConfiguration)ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class)).orElse(new BookiesRackConfiguration());
        return (BookieInfo)racks.getBookie(bookieAddress).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Bookie address not found: " + bookieAddress));
    }

    @DELETE
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Removed the rack placement information for a specific bookie in the cluster")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void deleteBookieRackInfo(@PathParam(value="bookie") String bookieAddress) throws Exception {
        BookiesRackConfiguration racks;
        this.validateSuperUserAccess();
        Optional entry = this.localZkCache().getEntry("/bookies", (key, content) -> (BookiesRackConfiguration)ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class));
        if (entry.isPresent()) {
            racks = (BookiesRackConfiguration)((Map.Entry)entry.get()).getKey();
            if (!racks.removeBookie(bookieAddress)) {
                throw new RestException(Response.Status.NOT_FOUND, "Bookie address not found: " + bookieAddress);
            }
        } else {
            throw new RestException(Response.Status.NOT_FOUND, "Bookie rack placement info is not found");
        }
        this.localZk().setData("/bookies", Bookies.jsonMapper().writeValueAsBytes((Object)racks), ((Stat)((Map.Entry)entry.get()).getValue()).getVersion());
        log.info("Removed {} from rack mapping info", (Object)bookieAddress);
    }

    @POST
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Updates the rack placement information for a specific bookie in the cluster (note. bookie address format:`address:port`)")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void updateBookieRackInfo(@PathParam(value="bookie") String bookieAddress, @QueryParam(value="group") String group, BookieInfo bookieInfo) throws Exception {
        this.validateSuperUserAccess();
        if (group == null) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Bookie 'group' parameters is missing");
        }
        int separatorCnt = StringUtils.countMatches((CharSequence)StringUtils.strip((String)bookieInfo.getRack(), (String)PATH_SEPARATOR), (CharSequence)PATH_SEPARATOR);
        boolean isRackEnabled = this.pulsar().getConfiguration().isBookkeeperClientRackawarePolicyEnabled();
        boolean isRegionEnabled = this.pulsar().getConfiguration().isBookkeeperClientRegionawarePolicyEnabled();
        if (isRackEnabled && (isRegionEnabled && separatorCnt != 1 || !isRegionEnabled && separatorCnt != 0)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Bookie 'rack' parameter is invalid, When `RackawareEnsemblePlacementPolicy` is enabled, the rack name is not allowed to contain slash (`/`) except for the beginning and end of the rack name string. When `RegionawareEnsemblePlacementPolicy` is enabled, the rack name can only contain one slash (`/`) except for the beginning and end of the rack name string.");
        }
        Optional entry = this.localZkCache().getEntry("/bookies", (key, content) -> (BookiesRackConfiguration)ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class));
        if (entry.isPresent()) {
            BookiesRackConfiguration racks = (BookiesRackConfiguration)((Map.Entry)entry.get()).getKey();
            racks.updateBookie(group, bookieAddress, bookieInfo);
            this.localZk().setData("/bookies", Bookies.jsonMapper().writeValueAsBytes((Object)racks), ((Stat)((Map.Entry)entry.get()).getValue()).getVersion());
            this.localZkCache().invalidate("/bookies");
            log.info("Updated rack mapping info for {}", (Object)bookieAddress);
        } else {
            BookiesRackConfiguration racks = new BookiesRackConfiguration();
            racks.updateBookie(group, bookieAddress, bookieInfo);
            this.zkCreate("/bookies", Bookies.jsonMapper().writeValueAsBytes((Object)racks));
            log.info("Created rack mapping info and added {}", (Object)bookieAddress);
        }
    }
}

