/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerDefinition;
import org.apache.pulsar.broker.protocol.ProtocolHandlerDefinitions;
import org.apache.pulsar.broker.protocol.ProtocolHandlerMetadata;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProtocolHandlerUtils {
    private static final Logger log = LoggerFactory.getLogger(ProtocolHandlerUtils.class);
    static final String PULSAR_PROTOCOL_HANDLER_DEFINITION_FILE = "pulsar-protocol-handler.yml";

    public static ProtocolHandlerDefinition getProtocolHandlerDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoader.getFromArchive((File)new File(narPath), Collections.emptySet(), (String)narExtractionDirectory);){
            ProtocolHandlerDefinition protocolHandlerDefinition = ProtocolHandlerUtils.getProtocolHandlerDefinition(ncl);
            return protocolHandlerDefinition;
        }
    }

    private static ProtocolHandlerDefinition getProtocolHandlerDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(PULSAR_PROTOCOL_HANDLER_DEFINITION_FILE);
        return (ProtocolHandlerDefinition)ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, ProtocolHandlerDefinition.class);
    }

    public static ProtocolHandlerDefinitions searchForHandlers(String handlersDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(handlersDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for protocol handlers in {}", (Object)path);
        ProtocolHandlerDefinitions handlers = new ProtocolHandlerDefinitions();
        if (!path.toFile().exists()) {
            log.warn("Protocol handler directory not found");
            return handlers;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    ProtocolHandlerDefinition phDef = ProtocolHandlerUtils.getProtocolHandlerDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found protocol handler from {} : {}", (Object)archive, (Object)phDef);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phDef.getName()));
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phDef.getHandlerClass()));
                    ProtocolHandlerMetadata metadata = new ProtocolHandlerMetadata();
                    metadata.setDefinition(phDef);
                    metadata.setArchivePath(archive);
                    handlers.handlers().put(phDef.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load connector from {}. It is OK however if you want to use this protocol handler, please make sure you put the correct protocol handler NAR package in the handlers directory.", (Object)archive, (Object)t);
                }
            }
        }
        return handlers;
    }

    static ProtocolHandlerWithClassLoader load(ProtocolHandlerMetadata metadata, String narExtractionDirectory) throws IOException {
        NarClassLoader ncl = NarClassLoader.getFromArchive((File)metadata.getArchivePath().toAbsolutePath().toFile(), Collections.emptySet(), (ClassLoader)ProtocolHandler.class.getClassLoader(), (String)narExtractionDirectory);
        ProtocolHandlerDefinition phDef = ProtocolHandlerUtils.getProtocolHandlerDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)phDef.getHandlerClass())) {
            throw new IOException("Protocol handler `" + phDef.getName() + "` does NOT provide a protocol handler implementation");
        }
        try {
            Class handlerClass = ncl.loadClass(phDef.getHandlerClass());
            Object handler = handlerClass.newInstance();
            if (!(handler instanceof ProtocolHandler)) {
                throw new IOException("Class " + phDef.getHandlerClass() + " does not implement protocol handler interface");
            }
            ProtocolHandler ph = (ProtocolHandler)handler;
            return new ProtocolHandlerWithClassLoader(ph, ncl);
        }
        catch (Throwable t) {
            ProtocolHandlerUtils.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    private ProtocolHandlerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

