/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceEventsSystemTopicFactory {
    private final PulsarClient client;
    private static final Logger log = LoggerFactory.getLogger(NamespaceEventsSystemTopicFactory.class);

    public NamespaceEventsSystemTopicFactory(PulsarClient client) {
        this.client = client;
    }

    public TopicPoliciesSystemTopicClient createTopicPoliciesSystemTopicClient(NamespaceName namespaceName) {
        TopicName topicName = TopicName.get((String)"persistent", (NamespaceName)namespaceName, (String)"__change_events");
        log.info("Create topic policies system topic client {}", (Object)topicName.toString());
        return new TopicPoliciesSystemTopicClient(this.client, topicName);
    }

    public SystemTopicClient createSystemTopic(NamespaceName namespaceName, EventType eventType) {
        TopicName topicName = NamespaceEventsSystemTopicFactory.getSystemTopicName(namespaceName, eventType);
        if (topicName != null) {
            log.info("Create system topic {} for {}", (Object)topicName.toString(), (Object)eventType);
            return new TopicPoliciesSystemTopicClient(this.client, topicName);
        }
        return null;
    }

    public static TopicName getSystemTopicName(NamespaceName namespaceName, EventType eventType) {
        switch (eventType) {
            case TOPIC_POLICY: {
                return TopicName.get((String)"persistent", (NamespaceName)namespaceName, (String)"__change_events");
            }
        }
        return null;
    }
}

