/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.TimeAverageBrokerData;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;

public class BrokerData {
    private LocalBrokerData localData;
    private TimeAverageBrokerData timeAverageData;
    private Map<String, BundleData> preallocatedBundleData;

    public BrokerData(LocalBrokerData localData) {
        this.localData = localData;
        this.timeAverageData = new TimeAverageBrokerData();
        this.preallocatedBundleData = new ConcurrentHashMap<String, BundleData>();
    }

    public LocalBrokerData getLocalData() {
        return this.localData;
    }

    public TimeAverageBrokerData getTimeAverageData() {
        return this.timeAverageData;
    }

    public Map<String, BundleData> getPreallocatedBundleData() {
        return this.preallocatedBundleData;
    }

    public void setLocalData(LocalBrokerData localData) {
        this.localData = localData;
    }

    public void setTimeAverageData(TimeAverageBrokerData timeAverageData) {
        this.timeAverageData = timeAverageData;
    }

    public void setPreallocatedBundleData(Map<String, BundleData> preallocatedBundleData) {
        this.preallocatedBundleData = preallocatedBundleData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerData)) {
            return false;
        }
        BrokerData other = (BrokerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalBrokerData this$localData = this.getLocalData();
        LocalBrokerData other$localData = other.getLocalData();
        if (this$localData == null ? other$localData != null : !this$localData.equals(other$localData)) {
            return false;
        }
        TimeAverageBrokerData this$timeAverageData = this.getTimeAverageData();
        TimeAverageBrokerData other$timeAverageData = other.getTimeAverageData();
        if (this$timeAverageData == null ? other$timeAverageData != null : !((Object)this$timeAverageData).equals(other$timeAverageData)) {
            return false;
        }
        Map<String, BundleData> this$preallocatedBundleData = this.getPreallocatedBundleData();
        Map<String, BundleData> other$preallocatedBundleData = other.getPreallocatedBundleData();
        return !(this$preallocatedBundleData == null ? other$preallocatedBundleData != null : !((Object)this$preallocatedBundleData).equals(other$preallocatedBundleData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalBrokerData $localData = this.getLocalData();
        result = result * 59 + ($localData == null ? 43 : $localData.hashCode());
        TimeAverageBrokerData $timeAverageData = this.getTimeAverageData();
        result = result * 59 + ($timeAverageData == null ? 43 : ((Object)$timeAverageData).hashCode());
        Map<String, BundleData> $preallocatedBundleData = this.getPreallocatedBundleData();
        result = result * 59 + ($preallocatedBundleData == null ? 43 : ((Object)$preallocatedBundleData).hashCode());
        return result;
    }

    public String toString() {
        return "BrokerData(localData=" + this.getLocalData() + ", timeAverageData=" + this.getTimeAverageData() + ", preallocatedBundleData=" + this.getPreallocatedBundleData() + ")";
    }
}

