/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingServiceShutdownHook
extends Thread
implements ZooKeeperSessionWatcher.ShutdownService {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingServiceShutdownHook.class);
    private PulsarService service = null;
    private final Consumer<Integer> processTerminator;

    public MessagingServiceShutdownHook(PulsarService service, Consumer<Integer> processTerminator) {
        this.service = service;
        this.processTerminator = processTerminator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.service.getConfiguration() != null) {
            LOG.info("messaging service shutdown hook started, lookup webservice=" + this.service.getSafeWebServiceAddress() + ", broker url=" + this.service.getSafeBrokerServiceUrl());
        }
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("shutdown-thread"));
        try {
            try {
                CompletableFuture future = new CompletableFuture();
                executor.execute(() -> {
                    try {
                        this.service.closeAsync().whenComplete((result, throwable) -> {
                            if (throwable != null) {
                                future.completeExceptionally((Throwable)throwable);
                            } else {
                                future.complete(result);
                            }
                        });
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                });
                future.get(this.service.getConfiguration().getBrokerShutdownTimeoutMs(), TimeUnit.MILLISECONDS);
                LOG.info("Completed graceful shutdown. Exiting");
            }
            catch (CancellationException | TimeoutException e) {
                LOG.warn("Graceful shutdown timeout expired. Closing now");
            }
            catch (Exception e) {
                LOG.error("Failed to perform graceful shutdown, Exiting anyway", (Throwable)e);
            }
            finally {
                this.processTerminator.accept(0);
            }
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    public void shutdown(int exitCode) {
        try {
            if (this.service != null && this.service.getZkClient().getState() != ZooKeeper.States.CLOSED) {
                this.service.getZkClient().close();
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        LOG.info("Invoking Runtime.halt({})", (Object)exitCode);
        this.processTerminator.accept(exitCode);
    }
}

