/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;

public class ZkAdminPaths {
    public static final String POLICIES = "policies";
    public static final String PARTITIONED_TOPIC_PATH_ZNODE = "partitioned-topics";

    public static String partitionedTopicPath(TopicName name) {
        return ZkAdminPaths.adminPath(PARTITIONED_TOPIC_PATH_ZNODE, name.getNamespace(), name.getDomain().value(), name.getEncodedLocalName());
    }

    public static String managedLedgerPath(TopicName name) {
        return "/managed-ledgers/" + name.getPersistenceNamingEncoding();
    }

    public static String namespacePoliciesPath(NamespaceName name) {
        return ZkAdminPaths.adminPath(POLICIES, name.toString());
    }

    private static String adminPath(String ... parts) {
        return "/admin/" + String.join((CharSequence)"/", parts);
    }

    private ZkAdminPaths() {
    }
}

