/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQuotaCache {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceQuotaCache.class);
    public static final String RESOURCE_QUOTA_ROOT = "/loadbalance/resource-quota";
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();
    private final ZooKeeperDataCache<ResourceQuota> resourceQuotaCache;
    private final ZooKeeperCache localZkCache;
    private static final ResourceQuota initialQuota;

    private static String path(String suName) {
        if (suName != null && !suName.isEmpty()) {
            return "/loadbalance/resource-quota/namespace/" + suName;
        }
        return "/loadbalance/resource-quota/default";
    }

    public ResourceQuotaCache(ZooKeeperCache cache) {
        this.localZkCache = cache;
        this.resourceQuotaCache = new ZooKeeperDataCache<ResourceQuota>(cache){

            public ResourceQuota deserialize(String path, byte[] content) throws Exception {
                return (ResourceQuota)ResourceQuotaCache.this.jsonMapper.readValue(content, ResourceQuota.class);
            }
        };
    }

    public static ResourceQuota getInitialQuotaValue() {
        return initialQuota;
    }

    private ResourceQuota readQuotaFromZnode(String zpath) {
        try {
            return this.resourceQuotaCache.get(zpath).orElseGet(() -> new ResourceQuota());
        }
        catch (Exception e) {
            LOG.warn("Failed to read quota from znode {}: {}", (Object)zpath, (Object)e);
            return new ResourceQuota();
        }
    }

    private void saveQuotaToZnode(String zpath, ResourceQuota quota) throws Exception {
        ZooKeeper zk = this.localZkCache.getZooKeeper();
        if (zk.exists(zpath, false) == null) {
            try {
                ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)zpath, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        zk.setData(zpath, this.jsonMapper.writeValueAsBytes((Object)quota), -1);
    }

    public void initZK() throws PulsarServerException {
        String zpath = ResourceQuotaCache.path(null);
        ResourceQuota quota = this.readQuotaFromZnode(zpath);
        if (!quota.isValid()) {
            quota = ResourceQuotaCache.getInitialQuotaValue();
            try {
                this.saveQuotaToZnode(zpath, quota);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
    }

    public ResourceQuota getQuota(String suName) {
        String defaultZpath;
        String zpath = ResourceQuotaCache.path(suName);
        ResourceQuota quota = this.readQuotaFromZnode(zpath);
        if (!quota.isValid() && !(quota = this.readQuotaFromZnode(defaultZpath = ResourceQuotaCache.path(null))).isValid()) {
            quota = ResourceQuotaCache.getInitialQuotaValue();
        }
        return quota;
    }

    public ResourceQuota getQuota(NamespaceBundle suName) {
        String suNameStr = suName == null ? null : suName.toString();
        return this.getQuota(suNameStr);
    }

    public ResourceQuota getDefaultQuota() {
        return this.getQuota((String)null);
    }

    public void setQuota(String suName, ResourceQuota quota) throws Exception {
        String zpath = ResourceQuotaCache.path(suName);
        this.resourceQuotaCache.invalidate(zpath);
        this.saveQuotaToZnode(zpath, quota);
    }

    public void setQuota(NamespaceBundle suName, ResourceQuota quota) throws Exception {
        String suNameStr = suName == null ? null : suName.toString();
        this.setQuota(suNameStr, quota);
    }

    public void setDefaultQuota(ResourceQuota quota) throws Exception {
        this.setQuota((String)null, quota);
    }

    public void unsetQuota(String suName) throws Exception {
        this.setQuota(suName, new ResourceQuota());
    }

    public void unsetQuota(NamespaceBundle suName) throws Exception {
        String suNameStr = suName == null ? null : suName.toString();
        this.unsetQuota(suNameStr);
    }

    static {
        ResourceQuota quota = new ResourceQuota();
        quota.setMsgRateIn(40.0);
        quota.setMsgRateOut(120.0);
        quota.setBandwidthIn(100000.0);
        quota.setBandwidthOut(300000.0);
        quota.setMemory(80.0);
        quota.setDynamic(true);
        initialQuota = quota;
    }
}

