/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopLoadManager
implements LoadManager {
    private static final Logger log = LoggerFactory.getLogger(NoopLoadManager.class);
    private PulsarService pulsar;
    private String lookupServiceAddress;
    private ResourceUnit localResourceUnit;
    private LockManager<LocalBrokerData> lockManager;

    @Override
    public void initialize(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.lockManager = pulsar.getCoordinationService().getLockManager(LocalBrokerData.class);
    }

    @Override
    public void start() throws PulsarServerException {
        this.lookupServiceAddress = this.getBrokerAddress();
        this.localResourceUnit = new SimpleResourceUnit(String.format("http://%s", this.lookupServiceAddress), new PulsarResourceDescription());
        LocalBrokerData localData = new LocalBrokerData(this.pulsar.getSafeWebServiceAddress(), this.pulsar.getWebServiceAddressTls(), this.pulsar.getSafeBrokerServiceUrl(), this.pulsar.getBrokerServiceUrlTls());
        localData.setProtocols(this.pulsar.getProtocolDataToAdvertise());
        String brokerReportPath = "/loadbalance/brokers/" + this.lookupServiceAddress;
        try {
            log.info("Acquiring broker resource lock on {}", (Object)brokerReportPath);
            this.lockManager.acquireLock(brokerReportPath, (Object)localData).join();
            log.info("Acquired broker resource lock on {}", (Object)brokerReportPath);
        }
        catch (CompletionException ce) {
            throw new PulsarServerException((Throwable)MetadataStoreException.unwrap((Throwable)ce));
        }
    }

    private String getBrokerAddress() {
        return String.format("%s:%s", this.pulsar.getAdvertisedAddress(), this.pulsar.getConfiguration().getWebServicePort().isPresent() ? (Integer)this.pulsar.getConfiguration().getWebServicePort().get() : (Integer)this.pulsar.getConfiguration().getWebServicePortTls().get());
    }

    @Override
    public boolean isCentralized() {
        return false;
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId su) throws Exception {
        return Optional.of(this.localResourceUnit);
    }

    @Override
    public LoadManagerReport generateLoadReport() throws Exception {
        return null;
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
    }

    @Override
    public void writeLoadReportOnZookeeper() throws Exception {
    }

    @Override
    public void writeResourceQuotasToZooKeeper() throws Exception {
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        return Collections.emptyList();
    }

    @Override
    public void doLoadShedding() {
    }

    @Override
    public void doNamespaceBundleSplit() throws Exception {
    }

    @Override
    public void disableBroker() throws Exception {
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return Collections.singleton(this.lookupServiceAddress);
    }

    @Override
    public void stop() throws PulsarServerException {
        if (this.lockManager != null) {
            try {
                this.lockManager.close();
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
    }
}

