/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.util.RetryUtil;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.FutureUtil;

public interface TopicPoliciesService {
    public static final TopicPoliciesService DISABLED = new TopicPoliciesServiceDisabled();
    public static final long DEFAULT_GET_TOPIC_POLICY_TIMEOUT = 30000L;

    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName var1);

    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName var1, TopicPolicies var2);

    public TopicPolicies getTopicPolicies(TopicName var1) throws BrokerServiceException.TopicPoliciesCacheNotInitException;

    default public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName, Backoff backoff, ScheduledExecutorService scheduledExecutorService) {
        CompletableFuture<Optional<TopicPolicies>> response = new CompletableFuture<Optional<TopicPolicies>>();
        Backoff usedBackoff = backoff == null ? new BackoffBuilder().setInitialTime(500L, TimeUnit.MILLISECONDS).setMandatoryStop(30000L, TimeUnit.MILLISECONDS).setMax(30000L, TimeUnit.MILLISECONDS).create() : backoff;
        try {
            RetryUtil.retryAsynchronously(() -> {
                CompletableFuture<Optional<TopicPolicies>> future = new CompletableFuture<Optional<TopicPolicies>>();
                try {
                    future.complete(Optional.ofNullable(this.getTopicPolicies(topicName)));
                }
                catch (BrokerServiceException.TopicPoliciesCacheNotInitException exception) {
                    future.completeExceptionally(exception);
                }
                return future;
            }, (Backoff)usedBackoff, (ScheduledExecutorService)scheduledExecutorService, response);
        }
        catch (Exception e) {
            response.completeExceptionally(e);
        }
        return response;
    }

    public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName var1);

    public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle var1);

    public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle var1);

    public void start();

    public void registerListener(TopicName var1, TopicPolicyListener<TopicPolicies> var2);

    public void unregisterListener(TopicName var1, TopicPolicyListener<TopicPolicies> var2);

    default public void clean(TopicName topicName) {
        throw new UnsupportedOperationException("Clean is not supported by default");
    }

    public static class TopicPoliciesServiceDisabled
    implements TopicPoliciesService {
        @Override
        public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
            return FutureUtil.failedFuture((Throwable)new UnsupportedOperationException("Topic policies service is disabled."));
        }

        @Override
        public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
            return FutureUtil.failedFuture((Throwable)new UnsupportedOperationException("Topic policies service is disabled."));
        }

        @Override
        public TopicPolicies getTopicPolicies(TopicName topicName) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
            return null;
        }

        @Override
        public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName topicName) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void start() {
        }

        @Override
        public void registerListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        }

        @Override
        public void unregisterListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        }

        @Override
        public void clean(TopicName topicName) {
        }
    }
}

