/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;

public class NamespaceBundle
implements ServiceUnitId,
Comparable<NamespaceBundle> {
    private final NamespaceName nsname;
    private final Range<Long> keyRange;
    private final NamespaceBundleFactory factory;
    private boolean hasNonPersistentTopic = false;
    private final String key;
    private final String bundleRange;

    public NamespaceBundle(NamespaceName nsname, Range<Long> keyRange, NamespaceBundleFactory factory) {
        this.nsname = (NamespaceName)Preconditions.checkNotNull((Object)nsname);
        this.keyRange = (Range)Preconditions.checkNotNull(keyRange);
        Preconditions.checkArgument((boolean)this.keyRange.lowerBoundType().equals((Object)BoundType.CLOSED), (Object)"Invalid hash range. Lower Endpoint has to be inclusive");
        Preconditions.checkArgument((((Long)this.keyRange.upperEndpoint()).equals(NamespaceBundles.FULL_UPPER_BOUND) && this.keyRange.upperBoundType().equals((Object)BoundType.CLOSED) || !((Long)this.keyRange.upperEndpoint()).equals(NamespaceBundles.FULL_UPPER_BOUND) && this.keyRange.upperBoundType().equals((Object)BoundType.OPEN) ? 1 : 0) != 0, (Object)"Invalid hash range. Upper Endpoint should be exclusive unless it is 0xffffffff");
        Preconditions.checkArgument((!this.keyRange.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create bundle object for an empty key range");
        this.factory = (NamespaceBundleFactory)Preconditions.checkNotNull((Object)factory);
        this.key = NamespaceBundle.getKey(this.nsname, this.keyRange);
        this.bundleRange = String.format("0x%08x_0x%08x", keyRange.lowerEndpoint(), keyRange.upperEndpoint());
    }

    public NamespaceName getNamespaceObject() {
        return this.nsname;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public int compareTo(NamespaceBundle other) {
        if (this.nsname.toString().compareTo(other.nsname.toString()) != 0) {
            return this.nsname.toString().compareTo(other.nsname.toString());
        }
        if (this.equals(other)) {
            return 0;
        }
        try {
            Preconditions.checkState((boolean)this.keyRange.intersection(other.keyRange).isEmpty(), (Object)"Can't compare two key ranges with non-empty intersection set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException(ise.getMessage(), ise);
        }
        return ((Long)this.keyRange.lowerEndpoint()).compareTo((Long)other.keyRange.lowerEndpoint());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nsname, this.keyRange.lowerEndpoint(), this.keyRange.lowerBoundType(), this.keyRange.upperEndpoint(), this.keyRange.upperBoundType()});
    }

    public boolean equals(Object other) {
        if (other instanceof NamespaceBundle) {
            NamespaceBundle obj = (NamespaceBundle)other;
            return Objects.equal((Object)this.nsname, (Object)obj.nsname) && Objects.equal((Object)this.keyRange.lowerEndpoint(), (Object)obj.keyRange.lowerEndpoint()) && Objects.equal((Object)this.keyRange.lowerBoundType(), (Object)obj.keyRange.lowerBoundType()) && Objects.equal((Object)this.keyRange.upperEndpoint(), (Object)obj.keyRange.upperEndpoint()) && Objects.equal((Object)this.keyRange.upperBoundType(), (Object)obj.keyRange.upperBoundType());
        }
        return false;
    }

    public boolean includes(TopicName topicName) {
        if (!this.nsname.equals((Object)topicName.getNamespaceObject())) {
            return false;
        }
        return this.keyRange.contains((Comparable)Long.valueOf(this.factory.getLongHashCode(topicName.toString())));
    }

    public String getBundleRange() {
        return this.bundleRange;
    }

    private static String getKey(NamespaceName nsname, Range<Long> keyRange) {
        return String.format("%s/0x%08x_0x%08x", nsname, keyRange.lowerEndpoint(), keyRange.upperEndpoint());
    }

    Range<Long> getKeyRange() {
        return this.keyRange;
    }

    Long getLowerEndpoint() {
        return (Long)this.keyRange.lowerEndpoint();
    }

    Long getUpperEndpoint() {
        return (Long)this.keyRange.upperEndpoint();
    }

    public boolean hasNonPersistentTopic() {
        return this.hasNonPersistentTopic;
    }

    public void setHasNonPersistentTopic(boolean hasNonPersistentTopic) {
        this.hasNonPersistentTopic = hasNonPersistentTopic;
    }

    public static String getBundleRange(String namespaceBundle) {
        return namespaceBundle.substring(namespaceBundle.lastIndexOf(47) + 1);
    }

    public NamespaceBundleFactory getNamespaceBundleFactory() {
        return this.factory;
    }
}

