/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker-stats")
public class WorkerStats
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(WorkerStats.class);

    public Workers<? extends WorkerService> workers() {
        return this.validateAndGetWorkerService().getWorkers();
    }

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Request should be executed by Monitoring agent on each worker to fetch the worker-metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    @Produces(value={"application/json"})
    public Collection<Metrics> getMetrics() throws Exception {
        return this.workers().getWorkerMetrics(this.authParams());
    }

    @GET
    @Path(value="/functionsmetrics")
    @ApiOperation(value="Get metrics for all functions owned by worker", notes="Requested should be executed by Monitoring agent on each worker to fetch the metrics", response=WorkerFunctionInstanceStats.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    @Produces(value={"application/json"})
    public List<WorkerFunctionInstanceStats> getStats() throws IOException {
        return this.workers().getFunctionsMetrics(this.authParams());
    }
}

