/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.store;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStore;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStoreException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableViewLoadDataStoreImpl<T>
implements LoadDataStore<T> {
    private static final Logger log = LoggerFactory.getLogger(TableViewLoadDataStoreImpl.class);
    private static final long LOAD_DATA_REPORT_UPDATE_MAX_INTERVAL_MULTIPLIER_BEFORE_RESTART = 2L;
    private volatile TableView<T> tableView;
    private volatile long tableViewLastUpdateTimestamp;
    private volatile Producer<T> producer;
    private final ServiceConfiguration conf;
    private final PulsarClient client;
    private final String topic;
    private final Class<T> clazz;

    public TableViewLoadDataStoreImpl(PulsarService pulsar, String topic, Class<T> clazz) throws LoadDataStoreException {
        try {
            this.conf = pulsar.getConfiguration();
            this.client = pulsar.getClient();
            this.topic = topic;
            this.clazz = clazz;
        }
        catch (Exception e) {
            throw new LoadDataStoreException(e);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> pushAsync(String key, T loadData) {
        this.validateProducer();
        return this.producer.newMessage().key(key).value(loadData).sendAsync().thenAccept(__ -> {});
    }

    @Override
    public synchronized CompletableFuture<Void> removeAsync(String key) {
        this.validateProducer();
        return this.producer.newMessage().key(key).value(null).sendAsync().thenAccept(__ -> {});
    }

    @Override
    public synchronized Optional<T> get(String key) {
        this.validateTableView();
        return Optional.ofNullable(this.tableView.get(key));
    }

    @Override
    public synchronized void forEach(BiConsumer<String, T> action) {
        this.validateTableView();
        this.tableView.forEach(action);
    }

    @Override
    public synchronized Set<Map.Entry<String, T>> entrySet() {
        this.validateTableView();
        return this.tableView.entrySet();
    }

    @Override
    public synchronized int size() {
        this.validateTableView();
        return this.tableView.size();
    }

    @Override
    public synchronized void closeTableView() throws IOException {
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    @Override
    public synchronized void start() throws LoadDataStoreException {
        this.startProducer();
        this.startTableView();
    }

    @Override
    public synchronized void startTableView() throws LoadDataStoreException {
        if (this.tableView == null) {
            try {
                this.tableView = this.client.newTableViewBuilder(Schema.JSON(this.clazz)).topic(this.topic).create();
                this.tableView.forEachAndListen((k, v) -> {
                    this.tableViewLastUpdateTimestamp = System.currentTimeMillis();
                });
            }
            catch (PulsarClientException e) {
                this.tableView = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void startProducer() throws LoadDataStoreException {
        if (this.producer == null) {
            try {
                this.producer = this.client.newProducer(Schema.JSON(this.clazz)).topic(this.topic).create();
            }
            catch (PulsarClientException e) {
                this.producer = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        this.closeTableView();
    }

    @Override
    public synchronized void init() throws IOException {
        this.close();
        this.start();
    }

    private void validateProducer() {
        if (this.producer == null || !this.producer.isConnected()) {
            try {
                if (this.producer != null) {
                    this.producer.close();
                }
                this.producer = null;
                this.startProducer();
                log.info("Restarted producer on {}", (Object)this.topic);
            }
            catch (Exception e) {
                log.error("Failed to restart producer on {}", (Object)this.topic, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void validateTableView() {
        String restartReason = null;
        if (this.tableView == null) {
            restartReason = "table view is null";
        } else {
            long threshold;
            long inactiveDuration = System.currentTimeMillis() - this.tableViewLastUpdateTimestamp;
            if (inactiveDuration > (threshold = TimeUnit.MINUTES.toMillis(this.conf.getLoadBalancerReportUpdateMaxIntervalMinutes()) * 2L)) {
                restartReason = String.format("inactiveDuration=%d secs > threshold = %d secs", TimeUnit.MILLISECONDS.toSeconds(inactiveDuration), TimeUnit.MILLISECONDS.toSeconds(threshold));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)restartReason)) {
            this.tableViewLastUpdateTimestamp = 0L;
            try {
                this.closeTableView();
                this.startTableView();
                log.info("Restarted tableview on {}, {}", (Object)this.topic, (Object)restartReason);
            }
            catch (Exception e) {
                log.error("Failed to restart tableview on {}", (Object)this.topic, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

