/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import com.beust.jcommander.Parameters;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.BaseGenerateDocumentation;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documentation automatically.")
public class CmdGenerateDocumentation
extends BaseGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);

    public String generateDocumentByClassName(String className) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (ServiceConfiguration.class.getName().equals(className)) {
            return this.generateDocByFieldContext(className, "Broker", sb);
        }
        if (ClientConfigurationData.class.getName().equals(className)) {
            return this.generateDocByApiModelProperty(className, "Client", sb);
        }
        if (WebSocketProxyConfiguration.class.getName().equals(className)) {
            return this.generateDocByFieldContext(className, "WebSocket", sb);
        }
        return "Class [" + className + "] not found";
    }

    public static void main(String[] args) throws Exception {
        CmdGenerateDocumentation generateDocumentation = new CmdGenerateDocumentation();
        generateDocumentation.run(args);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CmdGenerateDocumentation)) {
            return false;
        }
        CmdGenerateDocumentation other = (CmdGenerateDocumentation)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CmdGenerateDocumentation;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CmdGenerateDocumentation()";
    }
}

