/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.bookkeeper.mledger.proto.PendingBookieOpsStats;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.stats.AllocatorStatsGenerator;
import org.apache.pulsar.broker.stats.BookieClientStatsGenerator;
import org.apache.pulsar.broker.stats.MBeanStatsGenerator;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LoadReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStatsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(BrokerStatsBase.class);

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Requested should be executed by Monitoring agent on each broker to fetch the metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> getMetrics() throws Exception {
        this.validateSuperUserAccess();
        try {
            Collection<Metrics> metrics = this.pulsar().getMetricsGenerator().generate();
            return metrics;
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate metrics", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/mbeans")
    @ApiOperation(value="Get all the mbean details of this broker JVM", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> getMBeans() throws Exception {
        this.validateSuperUserAccess();
        try {
            Collection<Metrics> metrics = MBeanStatsGenerator.generate(this.pulsar());
            return metrics;
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate mbean stats", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/destinations")
    @ApiOperation(value="Get all the topic stats by namespace", response=OutputStream.class, responseContainer="OutputStream")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public StreamingOutput getTopics2() throws Exception {
        this.validateSuperUserAccess();
        return output -> this.pulsar().getBrokerService().getDimensionMetrics(statsBuf -> {
            try {
                output.write(statsBuf.array(), statsBuf.arrayOffset(), statsBuf.readableBytes());
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        });
    }

    @GET
    @Path(value="/allocator-stats/{allocator}")
    @ApiOperation(value="Get the stats for the Netty allocator. Available allocators are 'default' and 'ml-cache'", response=AllocatorStats.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public AllocatorStats getAllocatorStats(@PathParam(value="allocator") String allocatorName) throws Exception {
        this.validateSuperUserAccess();
        try {
            return AllocatorStatsGenerator.generate(allocatorName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, e.getMessage());
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate allocator stats", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/bookieops")
    @ApiOperation(value="Get pending bookie client op stats by namespace", response=PendingBookieOpsStats.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Map<String, Map<String, PendingBookieOpsStats>> getPendingBookieOpsStats() {
        this.validateSuperUserAccess();
        try {
            return BookieClientStatsGenerator.generate(this.pulsar());
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate pending bookie ops stats for topics", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/load-report")
    @ApiOperation(value="Get Load for this broker", notes="consists of topics stats & systemResourceUsage", response=LoadReport.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public LoadManagerReport getLoadReport() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.pulsar().getLoadManager().get().generateLoadReport();
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate LoadReport for broker, reason [{}]", new Object[]{this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
    }

    protected Map<Long, Collection<ResourceUnit>> internalBrokerResourceAvailability(NamespaceName namespace) {
        try {
            this.validateSuperUserAccess();
            LoadManager lm = this.pulsar().getLoadManager().get();
            if (lm instanceof SimpleLoadManagerImpl) {
                return ((SimpleLoadManagerImpl)lm).getResourceAvailabilityFor((ServiceUnitId)namespace).asMap();
            }
            throw new RestException(Response.Status.CONFLICT, lm.getClass().getName() + " does not support this operation");
        }
        catch (Exception e) {
            log.error("Unable to get Resource Availability", (Throwable)e);
            throw new RestException(e);
        }
    }
}

