/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffloaderObjectsScannerUtils {
    private static final Logger log = LoggerFactory.getLogger(OffloaderObjectsScannerUtils.class);
    private static final String STATUS_OK = "OK";
    private static final String STATUS_UNKNOWN = "UNKNOWN";
    private static final String STATUS_BAD_UUID = "BAD-UUID";
    private static final String STATUS_NOT_FOUND = "NOT-FOUND";
    private static final String STATUS_NOT_OFFLOADED = "NOT-OFFLOADED";

    static void scanOffloadedLedgers(LedgerOffloader managedLedgerOffloader, String localClusterName, ManagedLedgerFactory managedLedgerFactory, ScannerResultSink sink) throws Exception {
        AtomicInteger totalCount = new AtomicInteger();
        AtomicInteger totalErrors = new AtomicInteger();
        AtomicInteger totalUnknown = new AtomicInteger();
        managedLedgerOffloader.scanLedgers(md -> {
            log.info("Found ledger {}", (Object)md);
            HashMap<String, Object> objectInfo = new HashMap<String, Object>();
            objectInfo.put("ledger", md.getLedgerId());
            objectInfo.put("name", md.getName());
            objectInfo.put("uri", md.getUri());
            objectInfo.put("uuid", md.getUuid());
            objectInfo.put("size", md.getSize());
            objectInfo.put("lastModified", md.getLastModified());
            objectInfo.put("userMetadata", md.getUserMetadata());
            String status = STATUS_UNKNOWN;
            if (md.getUserMetadata() != null) {
                String managedLedgerName;
                TreeMap userMetadata = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                userMetadata.putAll(md.getUserMetadata());
                String clusterName = (String)userMetadata.get("pulsarClusterName");
                if (localClusterName.equals(clusterName) && (managedLedgerName = (String)userMetadata.get("managedledgername")) != null) {
                    objectInfo.put("managedLedgerName", managedLedgerName);
                    try {
                        status = OffloaderObjectsScannerUtils.checkLedgerShouldBeOnTieredStorage(md.getLedgerId(), md.getUuid(), managedLedgerName, objectInfo, managedLedgerFactory);
                    }
                    catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(err);
                    }
                    catch (ManagedLedgerException err) {
                        log.error("Error while checking managed ledger {}", (Object)managedLedgerName);
                        throw new RuntimeException(err);
                    }
                }
            }
            totalCount.incrementAndGet();
            objectInfo.put("status", status);
            switch (status) {
                case "OK": {
                    break;
                }
                case "UNKNOWN": {
                    totalUnknown.incrementAndGet();
                    break;
                }
                default: {
                    totalErrors.incrementAndGet();
                }
            }
            sink.object(objectInfo);
            return true;
        }, managedLedgerOffloader.getOffloadDriverMetadata());
        sink.finished(totalCount.get(), totalErrors.get(), totalUnknown.get());
    }

    private static String checkLedgerShouldBeOnTieredStorage(long ledgerId, String uuid, String managedLedgerName, Map<String, Object> data, ManagedLedgerFactory managedLedgerFactory) throws InterruptedException, ManagedLedgerException {
        try {
            ManagedLedgerInfo managedLedgerInfo = managedLedgerFactory.getManagedLedgerInfo(managedLedgerName);
            ManagedLedgerInfo.LedgerInfo ledgerInfo = managedLedgerInfo.ledgers.stream().filter(l -> l.ledgerId == ledgerId).findAny().orElse(null);
            if (ledgerInfo == null) {
                log.info("Managed ledger {} does not contain ledger {}", (Object)managedLedgerName, (Object)ledgerId);
                return STATUS_NOT_FOUND;
            }
            data.put("numEntries", ledgerInfo.entries);
            data.put("offloaded", ledgerInfo.isOffloaded);
            if (!ledgerInfo.isOffloaded) {
                log.info("Ledger {} is not marked as OFFLOADED in {}", (Object)ledgerId, (Object)managedLedgerName);
                return STATUS_NOT_OFFLOADED;
            }
            String uuidOnMetadata = ledgerInfo.offloadedContextUuid;
            if (!Objects.equals(uuidOnMetadata, uuid)) {
                log.info("Ledger {} uuid {} does not match name uuid {}", new Object[]{ledgerId, uuidOnMetadata, uuid});
                return STATUS_BAD_UUID;
            }
            return STATUS_OK;
        }
        catch (ManagedLedgerException.ManagedLedgerNotFoundException | ManagedLedgerException.MetadataNotFoundException notFound) {
            log.info("Managed ledger {} does not exist (maybe the topic has been deleted)", (Object)managedLedgerName);
            return STATUS_NOT_FOUND;
        }
    }

    private OffloaderObjectsScannerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface ScannerResultSink {
        public void object(Map<String, Object> var1) throws Exception;

        public void finished(int var1, int var2, int var3) throws Exception;
    }
}

