/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ModularLoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;

public class ModularLoadManagerWrapper
implements LoadManager {
    private ModularLoadManager loadManager;

    public ModularLoadManagerWrapper(ModularLoadManager loadManager) {
        this.loadManager = loadManager;
    }

    @Override
    public void disableBroker() throws Exception {
        this.loadManager.disableBroker();
    }

    @Override
    public void doLoadShedding() {
        this.loadManager.doLoadShedding();
    }

    @Override
    public void doNamespaceBundleSplit() {
        this.loadManager.checkNamespaceBundleSplit();
    }

    @Override
    public LoadManagerReport generateLoadReport() {
        return this.loadManager.updateLocalBrokerData();
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId serviceUnit) {
        String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(serviceUnit.toString());
        String affinityBroker = this.loadManager.setNamespaceBundleAffinity(bundleRange, null);
        if (!StringUtils.isBlank((CharSequence)affinityBroker)) {
            return Optional.of(this.buildBrokerResourceUnit(affinityBroker));
        }
        Optional<String> leastLoadedBroker = this.loadManager.selectBrokerForAssignment(serviceUnit);
        return leastLoadedBroker.map(this::buildBrokerResourceUnit);
    }

    private String getBrokerWebServiceUrl(String broker) {
        LocalBrokerData localData = this.loadManager.getBrokerLocalData(broker);
        if (localData != null) {
            return localData.getWebServiceUrl() != null ? localData.getWebServiceUrl() : localData.getWebServiceUrlTls();
        }
        return String.format("http://%s", broker);
    }

    private String getBrokerZnodeName(String broker, String webServiceUrl) {
        String scheme = webServiceUrl.substring(0, webServiceUrl.indexOf("://"));
        return String.format("%s://%s", scheme, broker);
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        return this.loadManager.getLoadBalancingMetrics();
    }

    @Override
    public void initialize(PulsarService pulsar) {
        this.loadManager.initialize(pulsar);
    }

    @Override
    public boolean isCentralized() {
        return true;
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
    }

    @Override
    public void start() throws PulsarServerException {
        this.loadManager.start();
    }

    @Override
    public void stop() throws PulsarServerException {
        this.loadManager.stop();
    }

    @Override
    public void writeLoadReportOnZookeeper() {
        this.loadManager.writeBrokerDataOnZooKeeper();
    }

    @Override
    public void writeLoadReportOnZookeeper(boolean force) {
        this.loadManager.writeBrokerDataOnZooKeeper(force);
    }

    @Override
    public void writeResourceQuotasToZooKeeper() {
        this.loadManager.writeBundleDataOnZooKeeper();
    }

    public ModularLoadManager getLoadManager() {
        return this.loadManager;
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return this.loadManager.getAvailableBrokers();
    }

    @Override
    public CompletableFuture<Set<String>> getAvailableBrokersAsync() {
        return this.loadManager.getAvailableBrokersAsync();
    }

    private SimpleResourceUnit buildBrokerResourceUnit(String broker) {
        String webServiceUrl = this.getBrokerWebServiceUrl(broker);
        String brokerZnodeName = this.getBrokerZnodeName(broker, webServiceUrl);
        return new SimpleResourceUnit(webServiceUrl, new PulsarResourceDescription(), Map.of("__advertised_addr", brokerZnodeName));
    }

    @Override
    public String setNamespaceBundleAffinity(String bundle, String broker) {
        return this.loadManager.setNamespaceBundleAffinity(bundle, broker);
    }
}

