/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGenerator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsServlet;

public class PulsarPrometheusMetricsServlet
extends PrometheusMetricsServlet {
    private static final long serialVersionUID = 1L;
    private final PulsarService pulsar;
    private final boolean shouldExportTopicMetrics;
    private final boolean shouldExportConsumerMetrics;
    private final boolean shouldExportProducerMetrics;
    private final boolean splitTopicAndPartitionLabel;

    public PulsarPrometheusMetricsServlet(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean shouldExportProducerMetrics, boolean splitTopicAndPartitionLabel) {
        super(pulsar.getConfiguration().getMetricsServletTimeoutMs(), pulsar.getConfiguration().getClusterName());
        this.pulsar = pulsar;
        this.shouldExportTopicMetrics = includeTopicMetrics;
        this.shouldExportConsumerMetrics = includeConsumerMetrics;
        this.shouldExportProducerMetrics = shouldExportProducerMetrics;
        this.splitTopicAndPartitionLabel = splitTopicAndPartitionLabel;
    }

    protected void generateMetrics(String cluster, ServletOutputStream outputStream) throws IOException {
        PrometheusMetricsGenerator.generate(this.pulsar, this.shouldExportTopicMetrics, this.shouldExportConsumerMetrics, this.shouldExportProducerMetrics, this.splitTopicAndPartitionLabel, (OutputStream)outputStream, this.metricsProviders);
    }
}

