/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMonotonicSnapshotClock
implements MonotonicSnapshotClock,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMonotonicSnapshotClock.class);
    private final long sleepMillis;
    private final int sleepNanos;
    private final LongSupplier clockSource;
    private final Thread thread;
    private volatile long snapshotTickNanos;

    public DefaultMonotonicSnapshotClock(long snapshotIntervalNanos, LongSupplier clockSource) {
        if (snapshotIntervalNanos < TimeUnit.MILLISECONDS.toNanos(1L)) {
            throw new IllegalArgumentException("snapshotIntervalNanos must be at least 1 millisecond");
        }
        this.sleepMillis = TimeUnit.NANOSECONDS.toMillis(snapshotIntervalNanos);
        this.sleepNanos = (int)(snapshotIntervalNanos - TimeUnit.MILLISECONDS.toNanos(this.sleepMillis));
        this.clockSource = clockSource;
        this.updateSnapshotTickNanos();
        this.thread = new Thread(this::snapshotLoop, this.getClass().getSimpleName() + "-update-loop");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public long getTickNanos(boolean requestSnapshot) {
        if (requestSnapshot) {
            this.updateSnapshotTickNanos();
        }
        return this.snapshotTickNanos;
    }

    private void updateSnapshotTickNanos() {
        this.snapshotTickNanos = this.clockSource.getAsLong();
    }

    private void snapshotLoop() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                this.updateSnapshotTickNanos();
                try {
                    Thread.sleep(this.sleepMillis, this.sleepNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected fatal error that stopped the clock.", t);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
    }
}

