/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.util.List;
import org.apache.pulsar.PulsarClusterMetadataSetup;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import picocli.CommandLine;

public class PulsarInitialNamespaceSetup {
    public static int doMain(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return 0;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("initialize-namespace", (Object)commander);
                cmd.run(null);
                return 0;
            }
        }
        catch (Exception e) {
            commander.getErr().println(e);
            return 1;
        }
        if (arguments.configurationStore == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            commander.usage(commander.getOut());
            return 1;
        }
        try (MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initConfigMetadataStore(arguments.configurationStore, arguments.zkSessionTimeoutMillis);){
            PulsarResources pulsarResources = new PulsarResources(null, (MetadataStore)configStore);
            for (String namespace : arguments.namespaces) {
                NamespaceName namespaceName = null;
                try {
                    namespaceName = NamespaceName.get((String)namespace);
                }
                catch (Exception e) {
                    System.out.println("Invalid namespace name.");
                    int n = 1;
                    if (configStore != null) {
                        configStore.close();
                    }
                    return n;
                }
                PulsarClusterMetadataSetup.createTenantIfAbsent(pulsarResources, namespaceName.getTenant(), arguments.cluster);
                PulsarClusterMetadataSetup.createNamespaceIfAbsent(pulsarResources, namespaceName, arguments.cluster);
            }
        }
        System.out.println("Initial namespace setup success");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(PulsarInitialNamespaceSetup.doMain(args));
    }

    @CommandLine.Command(name="initialize-namespace", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Option(names={"-c", "--cluster"}, description={"Cluster name"}, required=true)
        private String cluster;
        @CommandLine.Option(names={"-cs", "--configuration-store"}, description={"Configuration Store connection string"}, required=true)
        private String configurationStore;
        @CommandLine.Option(names={"--zookeeper-session-timeout-ms"}, description={"Local zookeeper session timeout ms"})
        private int zkSessionTimeoutMillis = 30000;
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private List<String> namespaces;
        @CommandLine.Option(names={"-h", "--help"}, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

