/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.buffer.AbortedTxnProcessor;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.SnapshotSystemTopicInternalStats;
import org.apache.pulsar.common.policies.data.TransactionBufferInternalStats;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInfo;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionLogStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckInternalStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.stats.PositionInPendingAckStats;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TxnMeta;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(TransactionsBase.class);

    protected void internalListCoordinators(AsyncResponse asyncResponse) {
        PulsarAdmin admin;
        try {
            admin = this.pulsar().getAdminClient();
        }
        catch (PulsarServerException ex2) {
            asyncResponse.resume((Throwable)((Object)new RestException(ex2)));
            return;
        }
        HashMap result = new HashMap();
        ((CompletableFuture)admin.lookups().lookupPartitionedTopicAsync(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartitionedTopicName()).thenAccept(map -> {
            map.forEach((topicPartition, brokerServiceUrl) -> {
                int coordinatorId = TopicName.getPartitionIndex((String)topicPartition);
                result.put(coordinatorId, new TransactionCoordinatorInfo((long)coordinatorId, brokerServiceUrl));
            });
            asyncResponse.resume(result.values());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to list transaction coordinators: {}", new Object[]{this.clientAppId(), ex.getMessage(), ex});
            TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetCoordinatorStats(AsyncResponse asyncResponse, boolean authoritative, Integer coordinatorId) {
        if (coordinatorId != null) {
            this.validateTopicOwnership(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId.intValue()), authoritative);
            TransactionMetadataStore transactionMetadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId.intValue()));
            if (transactionMetadataStore == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                return;
            }
            asyncResponse.resume((Object)transactionMetadataStore.getCoordinatorStats());
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, false, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions == 0) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found")));
                    return;
                }
                ArrayList<CompletableFuture> transactionMetadataStoreInfoFutures = new ArrayList<CompletableFuture>();
                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                    try {
                        transactionMetadataStoreInfoFutures.add(this.pulsar().getAdminClient().transactions().getCoordinatorStatsByIdAsync(i));
                        continue;
                    }
                    catch (PulsarServerException e2) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e2)));
                        return;
                    }
                }
                HashMap stats = new HashMap();
                FutureUtil.waitForAll(transactionMetadataStoreInfoFutures).whenComplete((result, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                        return;
                    }
                    for (int i = 0; i < transactionMetadataStoreInfoFutures.size(); ++i) {
                        try {
                            stats.put(i, (TransactionCoordinatorStats)((CompletableFuture)transactionMetadataStoreInfoFutures.get(i)).get());
                            continue;
                        }
                        catch (Exception exception) {
                            asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                            return;
                        }
                    }
                    asyncResponse.resume((Object)stats);
                });
            })).exceptionally(ex -> {
                log.error("[{}] Failed to get transaction coordinator state.", (Object)this.clientAppId(), ex);
                TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                return null;
            });
        }
    }

    protected CompletableFuture<TransactionInPendingAckStats> internalGetTransactionInPendingAckStats(boolean authoritative, long mostSigBits, long leastSigBits, String subName) {
        return this.getExistingPersistentTopicAsync(authoritative).thenApply(topic -> topic.getTransactionInPendingAckStats(new TxnID(mostSigBits, leastSigBits), subName));
    }

    protected CompletableFuture<TransactionInBufferStats> internalGetTransactionInBufferStats(boolean authoritative, long mostSigBits, long leastSigBits) {
        return this.getExistingPersistentTopicAsync(authoritative).thenApply(topic -> topic.getTransactionInBufferStats(new TxnID(mostSigBits, leastSigBits)));
    }

    protected CompletableFuture<TransactionBufferStats> internalGetTransactionBufferStats(boolean authoritative, boolean lowWaterMarks, boolean segmentStats) {
        return this.getExistingPersistentTopicAsync(authoritative).thenApply(topic -> topic.getTransactionBufferStats(lowWaterMarks, segmentStats));
    }

    protected CompletableFuture<TransactionPendingAckStats> internalGetPendingAckStats(boolean authoritative, String subName, boolean lowWaterMarks) {
        return this.getExistingPersistentTopicAsync(authoritative).thenApply(topic -> topic.getTransactionPendingAckStats(subName, lowWaterMarks));
    }

    protected void internalGetTransactionMetadata(AsyncResponse asyncResponse, boolean authoritative, int mostSigBits, long leastSigBits) {
        try {
            this.validateTopicOwnership(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartition(mostSigBits), authoritative);
            CompletableFuture<TransactionMetadata> transactionMetadataFuture = new CompletableFuture<TransactionMetadata>();
            TxnMeta txnMeta = this.pulsar().getTransactionMetadataStoreService().getTxnMeta(new TxnID((long)mostSigBits, leastSigBits)).get();
            this.getTransactionMetadata(txnMeta, transactionMetadataFuture);
            asyncResponse.resume((Object)transactionMetadataFuture.get(10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                if (e.getCause() instanceof CoordinatorException.CoordinatorNotFoundException || e.getCause() instanceof CoordinatorException.TransactionNotFoundException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, e.getCause())));
                    return;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(e.getCause())));
            }
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    private void getTransactionMetadata(TxnMeta txnMeta, CompletableFuture<TransactionMetadata> transactionMetadataFuture) throws PulsarServerException {
        Transactions transactions = this.pulsar().getAdminClient().transactions();
        TransactionMetadata transactionMetadata = new TransactionMetadata();
        TxnID txnID = txnMeta.id();
        transactionMetadata.txnId = txnID.toString();
        transactionMetadata.status = txnMeta.status().name();
        transactionMetadata.openTimestamp = txnMeta.getOpenTimestamp();
        transactionMetadata.timeoutAt = txnMeta.getTimeoutAt();
        transactionMetadata.owner = txnMeta.getOwner();
        ArrayList ackedPartitionsFutures = new ArrayList();
        HashMap ackFutures = new HashMap();
        txnMeta.ackedPartitions().forEach(transactionSubscription -> {
            String topic = transactionSubscription.getTopic();
            String subName = transactionSubscription.getSubscription();
            CompletableFuture future = transactions.getTransactionInPendingAckStatsAsync(txnID, topic, subName);
            ackedPartitionsFutures.add(future);
            if (ackFutures.containsKey(topic)) {
                ((Map)ackFutures.get(topic)).put(transactionSubscription.getSubscription(), future);
            } else {
                HashMap<String, CompletableFuture> pendingAckStatsMap = new HashMap<String, CompletableFuture>();
                pendingAckStatsMap.put(transactionSubscription.getSubscription(), future);
                ackFutures.put(topic, pendingAckStatsMap);
            }
        });
        ArrayList producedPartitionsFutures = new ArrayList();
        HashMap produceFutures = new HashMap();
        txnMeta.producedPartitions().forEach(topic -> {
            CompletableFuture future = transactions.getTransactionInBufferStatsAsync(txnID, topic);
            producedPartitionsFutures.add(future);
            produceFutures.put(topic, future);
        });
        FutureUtil.waitForAll(ackedPartitionsFutures).whenComplete((v, e) -> {
            if (e != null) {
                transactionMetadataFuture.completeExceptionally((Throwable)e);
                return;
            }
            FutureUtil.waitForAll((Collection)producedPartitionsFutures).whenComplete((x, t) -> {
                if (t != null) {
                    transactionMetadataFuture.completeExceptionally((Throwable)e);
                    return;
                }
                HashMap ackedPartitions = new HashMap();
                HashMap<String, TransactionInBufferStats> producedPartitions = new HashMap<String, TransactionInBufferStats>();
                for (String topic : ackFutures.keySet()) {
                    HashMap<String, TransactionInPendingAckStats> subs = new HashMap<String, TransactionInPendingAckStats>();
                    for (String sub : ((Map)ackFutures.get(topic)).keySet()) {
                        try {
                            subs.put(sub, (TransactionInPendingAckStats)((CompletableFuture)((Map)ackFutures.get(topic)).get(sub)).get());
                        }
                        catch (Exception exception) {
                            transactionMetadataFuture.completeExceptionally(exception);
                            return;
                        }
                    }
                    ackedPartitions.put(topic, subs);
                }
                for (String topic : produceFutures.keySet()) {
                    try {
                        producedPartitions.put(topic, (TransactionInBufferStats)((CompletableFuture)produceFutures.get(topic)).get());
                    }
                    catch (Exception exception) {
                        transactionMetadataFuture.completeExceptionally(exception);
                        return;
                    }
                }
                transactionMetadata.ackedPartitions = ackedPartitions;
                transactionMetadata.producedPartitions = producedPartitions;
                transactionMetadataFuture.complete(transactionMetadata);
            });
        });
    }

    protected void internalGetSlowTransactions(AsyncResponse asyncResponse, boolean authoritative, long timeout, Integer coordinatorId) {
        try {
            if (coordinatorId != null) {
                this.validateTopicOwnership(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId.intValue()), authoritative);
                TransactionMetadataStore transactionMetadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId.intValue()));
                if (transactionMetadataStore == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                    return;
                }
                List transactions = transactionMetadataStore.getSlowTransactions(timeout);
                ArrayList<CompletableFuture<TransactionMetadata>> completableFutures = new ArrayList<CompletableFuture<TransactionMetadata>>();
                for (TxnMeta txnMeta : transactions) {
                    CompletableFuture<TransactionMetadata> completableFuture = new CompletableFuture<TransactionMetadata>();
                    this.getTransactionMetadata(txnMeta, completableFuture);
                    completableFutures.add(completableFuture);
                }
                FutureUtil.waitForAll(completableFutures).whenComplete((v, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e.getCause())));
                        return;
                    }
                    HashMap<String, TransactionMetadata> transactionMetadata = new HashMap<String, TransactionMetadata>();
                    for (CompletableFuture future : completableFutures) {
                        try {
                            transactionMetadata.put(((TransactionMetadata)future.get()).txnId, (TransactionMetadata)future.get());
                        }
                        catch (Exception exception) {
                            asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                            return;
                        }
                    }
                    asyncResponse.resume(transactionMetadata);
                });
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, false, false).thenAccept(partitionMetadata -> {
                    if (partitionMetadata.partitions == 0) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found")));
                        return;
                    }
                    ArrayList<CompletableFuture> completableFutures = new ArrayList<CompletableFuture>();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        try {
                            completableFutures.add(this.pulsar().getAdminClient().transactions().getSlowTransactionsByCoordinatorIdAsync(Integer.valueOf(i), timeout, TimeUnit.MILLISECONDS));
                            continue;
                        }
                        catch (PulsarServerException e2) {
                            asyncResponse.resume((Throwable)((Object)new RestException(e2)));
                            return;
                        }
                    }
                    HashMap transactionMetadataMaps = new HashMap();
                    FutureUtil.waitForAll(completableFutures).whenComplete((result, e) -> {
                        if (e != null) {
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                            return;
                        }
                        for (CompletableFuture transactionMetadataMap : completableFutures) {
                            try {
                                transactionMetadataMaps.putAll((Map)transactionMetadataMap.get());
                            }
                            catch (Exception exception) {
                                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                                return;
                            }
                        }
                        asyncResponse.resume((Object)transactionMetadataMaps);
                    });
                })).exceptionally(ex -> {
                    log.error("[{}] Failed to get transaction coordinator state.", (Object)this.clientAppId(), ex);
                    TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        }
        catch (Exception e2) {
            asyncResponse.resume((Throwable)((Object)new RestException(e2)));
        }
    }

    protected void internalGetCoordinatorInternalStats(AsyncResponse asyncResponse, boolean authoritative, boolean metadata, int coordinatorId) {
        try {
            TopicName topicName = SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId);
            this.validateTopicOwnership(topicName, authoritative);
            TransactionMetadataStore metadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId));
            if (metadataStore == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                return;
            }
            if (metadataStore instanceof MLTransactionMetadataStore) {
                ManagedLedger managedLedger = ((MLTransactionMetadataStore)metadataStore).getManagedLedger();
                TransactionCoordinatorInternalStats transactionCoordinatorInternalStats = new TransactionCoordinatorInternalStats();
                TransactionLogStats transactionLogStats = new TransactionLogStats();
                transactionLogStats.managedLedgerName = managedLedger.getName();
                transactionLogStats.managedLedgerInternalStats = (ManagedLedgerInternalStats)managedLedger.getManagedLedgerInternalStats(metadata).get();
                transactionCoordinatorInternalStats.transactionLogStats = transactionLogStats;
                asyncResponse.resume((Object)transactionCoordinatorInternalStats);
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker don't use MLTransactionMetadataStore!")));
            }
        }
        catch (Exception e) {
            TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    protected CompletableFuture<TransactionPendingAckInternalStats> internalGetPendingAckInternalStats(boolean authoritative, String subName, boolean metadata) {
        return ((CompletableFuture)this.getExistingPersistentTopicAsync(authoritative).thenCompose(topic -> topic.getPendingAckManagedLedger(subName))).thenCompose(managedLedger -> ((CompletableFuture)managedLedger.getManagedLedgerInternalStats(metadata).thenApply(internalStats -> {
            TransactionLogStats pendingAckLogStats = new TransactionLogStats();
            pendingAckLogStats.managedLedgerName = managedLedger.getName();
            pendingAckLogStats.managedLedgerInternalStats = internalStats;
            return pendingAckLogStats;
        })).thenApply(pendingAckLogStats -> {
            TransactionPendingAckInternalStats stats = new TransactionPendingAckInternalStats();
            stats.pendingAckLogStats = pendingAckLogStats;
            return stats;
        }));
    }

    protected CompletableFuture<TransactionBufferInternalStats> internalGetTransactionBufferInternalStats(boolean authoritative, boolean metadata) {
        TransactionBufferInternalStats transactionBufferInternalStats = new TransactionBufferInternalStats();
        return this.getExistingPersistentTopicAsync(authoritative).thenCompose(topic -> {
            AbortedTxnProcessor.SnapshotType snapshotType = topic.getTransactionBuffer().getSnapshotType();
            if (snapshotType == null) {
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction buffer Snapshot for the topic does not exist")));
            }
            if (snapshotType == AbortedTxnProcessor.SnapshotType.Segment) {
                transactionBufferInternalStats.snapshotType = snapshotType.toString();
                TopicName segmentTopic = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)this.namespaceName, (String)"__transaction_buffer_snapshot_segments");
                CompletableFuture<SnapshotSystemTopicInternalStats> segmentInternalStatsFuture = this.getTxnSnapshotInternalStats(segmentTopic, metadata);
                TopicName indexTopic = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)this.namespaceName, (String)"__transaction_buffer_snapshot_indexes");
                CompletableFuture<SnapshotSystemTopicInternalStats> segmentIndexInternalStatsFuture = this.getTxnSnapshotInternalStats(indexTopic, metadata);
                return segmentIndexInternalStatsFuture.thenCombine(segmentInternalStatsFuture, (indexStats, segmentStats) -> {
                    transactionBufferInternalStats.segmentIndexInternalStats = indexStats;
                    transactionBufferInternalStats.segmentInternalStats = segmentStats;
                    return transactionBufferInternalStats;
                });
            }
            if (snapshotType == AbortedTxnProcessor.SnapshotType.Single) {
                transactionBufferInternalStats.snapshotType = snapshotType.toString();
                TopicName singleSnapshotTopic = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)this.namespaceName, (String)"__transaction_buffer_snapshot");
                return this.getTxnSnapshotInternalStats(singleSnapshotTopic, metadata).thenApply(snapshotSystemTopicInternalStats -> {
                    transactionBufferInternalStats.singleSnapshotSystemTopicInternalStats = snapshotSystemTopicInternalStats;
                    return transactionBufferInternalStats;
                });
            }
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown SnapshotType " + snapshotType)));
        });
    }

    private CompletableFuture<SnapshotSystemTopicInternalStats> getTxnSnapshotInternalStats(TopicName topicName, boolean metadata) {
        PulsarAdmin admin;
        try {
            admin = this.pulsar().getAdminClient();
        }
        catch (PulsarServerException e) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(e)));
        }
        return admin.topics().getInternalStatsAsync(topicName.toString(), metadata).thenApply(persistentTopicInternalStats -> {
            SnapshotSystemTopicInternalStats snapshotSystemTopicInternalStats = new SnapshotSystemTopicInternalStats();
            snapshotSystemTopicInternalStats.managedLedgerInternalStats = persistentTopicInternalStats;
            snapshotSystemTopicInternalStats.managedLedgerName = topicName.getEncodedLocalName();
            return snapshotSystemTopicInternalStats;
        });
    }

    protected CompletableFuture<PersistentTopic> getExistingPersistentTopicAsync(boolean authoritative) {
        return this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> {
            CompletableFuture<Optional<Topic>> topicFuture = this.pulsar().getBrokerService().getTopics().get(this.topicName.toString());
            if (topicFuture == null) {
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, String.format("Topic not found %s", this.topicName.toString()))));
            }
            return topicFuture.thenCompose(optionalTopic -> {
                if (!optionalTopic.isPresent()) {
                    return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, String.format("Topic not found %s", this.topicName.toString()))));
                }
                return CompletableFuture.completedFuture((PersistentTopic)optionalTopic.get());
            });
        });
    }

    protected void checkTransactionCoordinatorEnabled() {
        if (!this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.");
        }
    }

    @Override
    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
            this.topicName = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected CompletableFuture<Void> internalScaleTransactionCoordinators(int replicas) {
        return this.validateSuperUserAccessAsync().thenCompose(ignore -> this.namespaceResources().getPartitionedTopicResources().updatePartitionedTopicAsync(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, p -> {
            if (p.partitions >= replicas) {
                throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of transaction coordinators should be more than the current number of transaction coordinator");
            }
            return new PartitionedTopicMetadata(replicas);
        }));
    }

    protected CompletableFuture<PositionInPendingAckStats> internalGetPositionStatsPendingAckStats(boolean authoritative, String subName, Position position, Integer batchIndex) {
        CompletableFuture<PositionInPendingAckStats> completableFuture = new CompletableFuture<PositionInPendingAckStats>();
        ((CompletableFuture)this.getExistingPersistentTopicAsync(authoritative).thenAccept(topic -> {
            PositionInPendingAckStats result = topic.getSubscription(subName).checkPositionInPendingAckState(position, batchIndex);
            completableFuture.complete(result);
        })).exceptionally(ex -> {
            completableFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return completableFuture;
    }

    protected CompletableFuture<Void> internalAbortTransaction(boolean authoritative, long mostSigBits, long leastSigBits) {
        if (mostSigBits < 0L || mostSigBits > Integer.MAX_VALUE) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("mostSigBits out of bounds"));
        }
        int partitionIdx = (int)mostSigBits;
        return ((CompletableFuture)this.validateTopicOwnershipAsync(SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN.getPartition(partitionIdx), authoritative).thenCompose(__ -> this.validateSuperUserAccessAsync())).thenCompose(__ -> this.pulsar().getTransactionMetadataStoreService().endTransaction(new TxnID(mostSigBits, leastSigBits), 1, false));
    }
}

