/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.ResourceGroup;

public class ResourceGroupPublishLimiter
extends PublishRateLimiterImpl {
    private volatile long publishMaxMessageRate;
    private volatile long publishMaxByteRate;

    public ResourceGroupPublishLimiter(ResourceGroup resourceGroup, MonotonicSnapshotClock monotonicSnapshotClock) {
        super(monotonicSnapshotClock);
        this.update(resourceGroup);
    }

    @Override
    public void update(Policies policies, String clusterName) {
    }

    @Override
    public void update(PublishRate maxPublishRate) {
    }

    public void update(ResourceGroup.BytesAndMessagesCount maxPublishRate) {
        this.update(maxPublishRate.messages, maxPublishRate.bytes);
    }

    public ResourceGroup.BytesAndMessagesCount getResourceGroupPublishValues() {
        ResourceGroup.BytesAndMessagesCount bmc = new ResourceGroup.BytesAndMessagesCount();
        bmc.bytes = this.publishMaxByteRate;
        bmc.messages = this.publishMaxMessageRate;
        return bmc;
    }

    public void update(ResourceGroup resourceGroup) {
        long publishRateInMsgs = 0L;
        long publishRateInBytes = 0L;
        if (resourceGroup != null) {
            publishRateInBytes = resourceGroup.getPublishRateInBytes() == null ? -1L : resourceGroup.getPublishRateInBytes();
            publishRateInMsgs = resourceGroup.getPublishRateInMsgs() == null ? -1L : (long)resourceGroup.getPublishRateInMsgs().intValue();
        }
        this.update(publishRateInMsgs, publishRateInBytes);
    }

    public void update(long publishRateInMsgs, long publishRateInBytes) {
        this.publishMaxMessageRate = publishRateInMsgs;
        this.publishMaxByteRate = publishRateInBytes;
        this.updateTokenBuckets(publishRateInMsgs, publishRateInBytes);
    }
}

