/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.OptionalProxyProtocolDecoder;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final PulsarService pulsar;
    private final String listenerName;
    private final boolean enableTls;
    private final ServiceConfiguration brokerConf;
    private PulsarSslFactory sslFactory;
    public static final Factory DEFAULT_FACTORY = PulsarChannelInitializer::new;

    public PulsarChannelInitializer(PulsarService pulsar, PulsarChannelOptions opts) throws Exception {
        this.pulsar = pulsar;
        this.listenerName = opts.getListenerName();
        this.enableTls = opts.isEnableTLS();
        ServiceConfiguration serviceConfig = pulsar.getConfiguration();
        if (this.enableTls) {
            PulsarSslConfiguration pulsarSslConfig = this.buildSslConfiguration(serviceConfig);
            this.sslFactory = (PulsarSslFactory)Class.forName(serviceConfig.getSslFactoryPlugin()).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sslFactory.initialize(pulsarSslConfig);
            this.sslFactory.createInternalSslContext();
            if (serviceConfig.getTlsCertRefreshCheckDurationSec() > 0L) {
                this.pulsar.getExecutor().scheduleWithFixedDelay(this::refreshSslContext, serviceConfig.getTlsCertRefreshCheckDurationSec(), serviceConfig.getTlsCertRefreshCheckDurationSec(), TimeUnit.SECONDS);
            }
        }
        this.brokerConf = pulsar.getConfiguration();
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.config().setAutoRead(false);
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        if (this.enableTls) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(this.sslFactory.createServerSslEngine(ch.alloc())));
        }
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.getEncoder((boolean)this.enableTls));
        if (this.pulsar.getConfiguration().isHaProxyProtocolEnabled()) {
            ch.pipeline().addLast("optional-proxy-protocol-decoder", (ChannelHandler)new OptionalProxyProtocolDecoder());
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.brokerConf.getMaxMessageSize() + 10240, 0, 4, 0, 4));
        ch.pipeline().addLast("flowController", (ChannelHandler)new FlowControlHandler());
        ServerCnx cnx = this.newServerCnx(this.pulsar, this.listenerName);
        ch.pipeline().addLast("handler", (ChannelHandler)cnx);
    }

    @VisibleForTesting
    protected ServerCnx newServerCnx(PulsarService pulsar, String listenerName) throws Exception {
        return new ServerCnx(pulsar, listenerName);
    }

    protected PulsarSslConfiguration buildSslConfiguration(ServiceConfiguration serviceConfig) {
        return PulsarSslConfiguration.builder().tlsKeyStoreType(serviceConfig.getTlsKeyStoreType()).tlsKeyStorePath(serviceConfig.getTlsKeyStore()).tlsKeyStorePassword(serviceConfig.getTlsKeyStorePassword()).tlsTrustStoreType(serviceConfig.getTlsTrustStoreType()).tlsTrustStorePath(serviceConfig.getTlsTrustStore()).tlsTrustStorePassword(serviceConfig.getTlsTrustStorePassword()).tlsCiphers(serviceConfig.getTlsCiphers()).tlsProtocols(serviceConfig.getTlsProtocols()).tlsTrustCertsFilePath(serviceConfig.getTlsTrustCertsFilePath()).tlsCertificateFilePath(serviceConfig.getTlsCertificateFilePath()).tlsKeyFilePath(serviceConfig.getTlsKeyFilePath()).allowInsecureConnection(serviceConfig.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(serviceConfig.isTlsRequireTrustedClientCertOnConnect()).tlsEnabledWithKeystore(serviceConfig.isTlsEnabledWithKeyStore()).tlsCustomParams(serviceConfig.getSslFactoryPluginParams()).serverMode(true).build();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }

    public static class PulsarChannelOptions {
        private boolean enableTLS;
        private String listenerName;

        PulsarChannelOptions(boolean enableTLS, String listenerName) {
            this.enableTLS = enableTLS;
            this.listenerName = listenerName;
        }

        public static PulsarChannelOptionsBuilder builder() {
            return new PulsarChannelOptionsBuilder();
        }

        public boolean isEnableTLS() {
            return this.enableTLS;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void setEnableTLS(boolean enableTLS) {
            this.enableTLS = enableTLS;
        }

        public void setListenerName(String listenerName) {
            this.listenerName = listenerName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PulsarChannelOptions)) {
                return false;
            }
            PulsarChannelOptions other = (PulsarChannelOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableTLS() != other.isEnableTLS()) {
                return false;
            }
            String this$listenerName = this.getListenerName();
            String other$listenerName = other.getListenerName();
            return !(this$listenerName == null ? other$listenerName != null : !this$listenerName.equals(other$listenerName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PulsarChannelOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableTLS() ? 79 : 97);
            String $listenerName = this.getListenerName();
            result = result * 59 + ($listenerName == null ? 43 : $listenerName.hashCode());
            return result;
        }

        public String toString() {
            return "PulsarChannelInitializer.PulsarChannelOptions(enableTLS=" + this.isEnableTLS() + ", listenerName=" + this.getListenerName() + ")";
        }

        public static class PulsarChannelOptionsBuilder {
            private boolean enableTLS;
            private String listenerName;

            PulsarChannelOptionsBuilder() {
            }

            public PulsarChannelOptionsBuilder enableTLS(boolean enableTLS) {
                this.enableTLS = enableTLS;
                return this;
            }

            public PulsarChannelOptionsBuilder listenerName(String listenerName) {
                this.listenerName = listenerName;
                return this;
            }

            public PulsarChannelOptions build() {
                return new PulsarChannelOptions(this.enableTLS, this.listenerName);
            }

            public String toString() {
                return "PulsarChannelInitializer.PulsarChannelOptions.PulsarChannelOptionsBuilder(enableTLS=" + this.enableTLS + ", listenerName=" + this.listenerName + ")";
            }
        }
    }

    public static interface Factory {
        public PulsarChannelInitializer newPulsarChannelInitializer(PulsarService var1, PulsarChannelOptions var2) throws Exception;
    }
}

