/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.util.concurrent.FastThreadLocal;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.stats.prometheus.AggregatedTransactionCoordinatorStats;
import org.apache.pulsar.broker.stats.prometheus.ManagedLedgerStats;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricStreams;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.impl.TransactionMetadataStoreStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAggregator {
    private static final Logger log = LoggerFactory.getLogger(TransactionAggregator.class);
    private static final FastThreadLocal<AggregatedTransactionCoordinatorStats> localTransactionCoordinatorStats = new FastThreadLocal<AggregatedTransactionCoordinatorStats>(){

        protected AggregatedTransactionCoordinatorStats initialValue() {
            return new AggregatedTransactionCoordinatorStats();
        }
    };
    private static final FastThreadLocal<ManagedLedgerStats> localManageLedgerStats = new FastThreadLocal<ManagedLedgerStats>(){

        protected ManagedLedgerStats initialValue() {
            return new ManagedLedgerStats();
        }
    };

    public static void generate(PulsarService pulsar, PrometheusMetricStreams stream, boolean includeTopicMetrics) {
        String cluster = pulsar.getConfiguration().getClusterName();
        if (includeTopicMetrics) {
            pulsar.getBrokerService().getMultiLayerTopicsMap().forEach((namespace, bundlesMap) -> bundlesMap.forEach((bundle, topicsMap) -> topicsMap.forEach((name, topic) -> {
                if (topic instanceof PersistentTopic) {
                    topic.getSubscriptions().values().forEach(subscription -> {
                        try {
                            ((ManagedLedgerStats)localManageLedgerStats.get()).reset();
                            if (!SystemTopicNames.isEventSystemTopic((TopicName)TopicName.get((String)subscription.getTopic().getName())) && subscription instanceof PersistentSubscription && ((PersistentSubscription)subscription).checkIfPendingAckStoreInit()) {
                                ManagedLedger managedLedger = ((PersistentSubscription)subscription).getPendingAckManageLedger().get();
                                TransactionAggregator.generateManageLedgerStats(managedLedger, stream, cluster, namespace, name, subscription.getName());
                            }
                        }
                        catch (Exception e) {
                            log.warn("Transaction pending ack generate managedLedgerStats fail!", (Throwable)e);
                        }
                    });
                }
            })));
        }
        AggregatedTransactionCoordinatorStats transactionCoordinatorStats = (AggregatedTransactionCoordinatorStats)localTransactionCoordinatorStats.get();
        pulsar.getTransactionMetadataStoreService().getStores().forEach((transactionCoordinatorID, transactionMetadataStore) -> {
            transactionCoordinatorStats.reset();
            TransactionMetadataStoreStats transactionMetadataStoreStats = transactionMetadataStore.getMetadataStoreStats();
            transactionCoordinatorStats.actives = transactionMetadataStoreStats.getActives();
            transactionCoordinatorStats.committedCount = transactionMetadataStoreStats.getCommittedCount();
            transactionCoordinatorStats.abortedCount = transactionMetadataStoreStats.getAbortedCount();
            transactionCoordinatorStats.createdCount = transactionMetadataStoreStats.getCreatedCount();
            transactionCoordinatorStats.timeoutCount = transactionMetadataStoreStats.getTimeoutCount();
            transactionCoordinatorStats.appendLogCount = transactionMetadataStoreStats.getAppendLogCount();
            transactionMetadataStoreStats.executionLatencyBuckets.refresh();
            transactionCoordinatorStats.executionLatency = transactionMetadataStoreStats.executionLatencyBuckets.getBuckets();
            TransactionAggregator.printTransactionCoordinatorStats(stream, cluster, transactionCoordinatorStats, transactionMetadataStoreStats.getCoordinatorId());
            ((ManagedLedgerStats)localManageLedgerStats.get()).reset();
            if (transactionMetadataStore instanceof MLTransactionMetadataStore) {
                ManagedLedger managedLedger = ((MLTransactionMetadataStore)transactionMetadataStore).getManagedLedger();
                TransactionAggregator.generateManageLedgerStats(managedLedger, stream, cluster, NamespaceName.SYSTEM_NAMESPACE.toString(), "__transaction_log_" + transactionCoordinatorID.getId(), "transaction.subscription");
            }
        });
    }

    private static void generateManageLedgerStats(ManagedLedger managedLedger, PrometheusMetricStreams stream, String cluster, String namespace, String topic, String subscription) {
        ManagedLedgerStats managedLedgerStats = (ManagedLedgerStats)localManageLedgerStats.get();
        ManagedLedgerMBeanImpl mlStats = (ManagedLedgerMBeanImpl)managedLedger.getStats();
        managedLedgerStats.storageSize = mlStats.getStoredMessagesSize();
        managedLedgerStats.storageLogicalSize = mlStats.getStoredMessagesLogicalSize();
        managedLedgerStats.backlogSize = managedLedger.getEstimatedBacklogSize();
        managedLedgerStats.offloadedStorageUsed = managedLedger.getOffloadedSize();
        managedLedgerStats.storageWriteLatencyBuckets.addAll(mlStats.getInternalAddEntryLatencyBuckets());
        managedLedgerStats.storageWriteLatencyBuckets.refresh();
        managedLedgerStats.storageLedgerWriteLatencyBuckets.addAll(mlStats.getInternalLedgerAddEntryLatencyBuckets());
        managedLedgerStats.storageLedgerWriteLatencyBuckets.refresh();
        managedLedgerStats.entrySizeBuckets.addAll(mlStats.getInternalEntrySizeBuckets());
        managedLedgerStats.entrySizeBuckets.refresh();
        managedLedgerStats.storageWriteRate = mlStats.getAddEntryMessagesRate();
        managedLedgerStats.storageReadRate = mlStats.getReadEntriesRate();
        TransactionAggregator.printManageLedgerStats(stream, cluster, namespace, topic, subscription, managedLedgerStats);
    }

    private static void printManageLedgerStats(PrometheusMetricStreams stream, String cluster, String namespace, String topic, String subscription, ManagedLedgerStats stats) {
        TransactionAggregator.writeMetric(stream, "pulsar_storage_size", stats.storageSize, cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_logical_size", stats.storageLogicalSize, cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_backlog_size", stats.backlogSize, cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_offloaded_size", stats.offloadedStorageUsed, cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_rate", stats.storageWriteRate, cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_read_rate", stats.storageReadRate, cluster, namespace, topic, subscription);
        stats.storageWriteLatencyBuckets.refresh();
        long[] latencyBuckets = stats.storageWriteLatencyBuckets.getBuckets();
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_0_5", latencyBuckets[0], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_1", latencyBuckets[1], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_5", latencyBuckets[2], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_10", latencyBuckets[3], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_20", latencyBuckets[4], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_50", latencyBuckets[5], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_100", latencyBuckets[6], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_200", latencyBuckets[7], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_le_1000", latencyBuckets[8], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_overflow", latencyBuckets[9], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_count", stats.storageWriteLatencyBuckets.getCount(), cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_write_latency_sum", stats.storageWriteLatencyBuckets.getSum(), cluster, namespace, topic, subscription);
        stats.storageLedgerWriteLatencyBuckets.refresh();
        long[] ledgerWriteLatencyBuckets = stats.storageLedgerWriteLatencyBuckets.getBuckets();
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_0_5", ledgerWriteLatencyBuckets[0], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_1", ledgerWriteLatencyBuckets[1], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_5", ledgerWriteLatencyBuckets[2], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_10", ledgerWriteLatencyBuckets[3], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_20", ledgerWriteLatencyBuckets[4], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_50", ledgerWriteLatencyBuckets[5], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_100", ledgerWriteLatencyBuckets[6], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_200", ledgerWriteLatencyBuckets[7], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_le_1000", ledgerWriteLatencyBuckets[8], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_overflow", ledgerWriteLatencyBuckets[9], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_count", stats.storageLedgerWriteLatencyBuckets.getCount(), cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_storage_ledger_write_latency_sum", stats.storageLedgerWriteLatencyBuckets.getSum(), cluster, namespace, topic, subscription);
        stats.entrySizeBuckets.refresh();
        long[] entrySizeBuckets = stats.entrySizeBuckets.getBuckets();
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_128", entrySizeBuckets[0], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_512", entrySizeBuckets[1], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_1_kb", entrySizeBuckets[2], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_2_kb", entrySizeBuckets[3], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_4_kb", entrySizeBuckets[4], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_16_kb", entrySizeBuckets[5], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_100_kb", entrySizeBuckets[6], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_1_mb", entrySizeBuckets[7], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_le_overflow", entrySizeBuckets[8], cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_count", stats.entrySizeBuckets.getCount(), cluster, namespace, topic, subscription);
        TransactionAggregator.writeMetric(stream, "pulsar_entry_size_sum", stats.entrySizeBuckets.getSum(), cluster, namespace, topic, subscription);
    }

    static void printTransactionCoordinatorStats(PrometheusMetricStreams stream, String cluster, AggregatedTransactionCoordinatorStats stats, long coordinatorId) {
        TransactionAggregator.writeMetric(stream, "pulsar_txn_active_count", stats.actives, cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_committed_total", stats.committedCount, cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_aborted_total", stats.abortedCount, cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_created_total", stats.createdCount, cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_timeout_total", stats.timeoutCount, cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_append_log_total", stats.appendLogCount, cluster, coordinatorId);
        long[] latencyBuckets = stats.executionLatency;
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_10", latencyBuckets[0], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_20", latencyBuckets[1], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_50", latencyBuckets[2], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_100", latencyBuckets[3], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_500", latencyBuckets[4], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_1000", latencyBuckets[5], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_5000", latencyBuckets[6], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_15000", latencyBuckets[7], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_30000", latencyBuckets[8], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_60000", latencyBuckets[9], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_300000", latencyBuckets[10], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_1500000", latencyBuckets[11], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_3000000", latencyBuckets[12], cluster, coordinatorId);
        TransactionAggregator.writeMetric(stream, "pulsar_txn_execution_latency_le_overflow", latencyBuckets[13], cluster, coordinatorId);
    }

    private static void writeMetric(PrometheusMetricStreams stream, String metricName, double value, String cluster, long coordinatorId) {
        stream.writeSample(metricName, value, "cluster", cluster, "coordinator_id", String.valueOf(coordinatorId));
    }

    private static void writeMetric(PrometheusMetricStreams stream, String metricName, Number value, String cluster, String namespace, String topic, String subscription) {
        stream.writeSample(metricName, value, "cluster", cluster, "namespace", namespace, "topic", topic, "subscription", subscription);
    }
}

