/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.function.LongSupplier;
import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.AsyncTokenBucketBuilder;
import org.apache.pulsar.broker.qos.DynamicRateAsyncTokenBucket;

public class DynamicRateAsyncTokenBucketBuilder
extends AsyncTokenBucketBuilder<DynamicRateAsyncTokenBucketBuilder> {
    protected LongSupplier rateFunction;
    protected double capacityFactor = 1.0;
    protected double initialFillFactor = 1.0;
    protected LongSupplier ratePeriodNanosFunction;
    protected double targetFillFactorAfterThrottling = 0.01;

    protected DynamicRateAsyncTokenBucketBuilder() {
    }

    public DynamicRateAsyncTokenBucketBuilder rateFunction(LongSupplier rateFunction) {
        this.rateFunction = rateFunction;
        return this;
    }

    public DynamicRateAsyncTokenBucketBuilder ratePeriodNanosFunction(LongSupplier ratePeriodNanosFunction) {
        this.ratePeriodNanosFunction = ratePeriodNanosFunction;
        return this;
    }

    public DynamicRateAsyncTokenBucketBuilder capacityFactor(double capacityFactor) {
        this.capacityFactor = capacityFactor;
        return this;
    }

    public DynamicRateAsyncTokenBucketBuilder initialFillFactor(double initialFillFactor) {
        this.initialFillFactor = initialFillFactor;
        return this;
    }

    public DynamicRateAsyncTokenBucketBuilder targetFillFactorAfterThrottling(double targetFillFactorAfterThrottling) {
        this.targetFillFactorAfterThrottling = targetFillFactorAfterThrottling;
        return this;
    }

    @Override
    public AsyncTokenBucket build() {
        return new DynamicRateAsyncTokenBucket(this.capacityFactor, this.rateFunction, this.clock, this.ratePeriodNanosFunction, this.resolutionNanos, this.initialFillFactor, this.targetFillFactorAfterThrottling);
    }
}

