/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.SystemTopicTxnBufferSnapshotService;
import org.apache.pulsar.broker.transaction.buffer.metadata.TransactionBufferSnapshot;
import org.apache.pulsar.broker.transaction.buffer.metadata.v2.TransactionBufferSnapshotIndexes;
import org.apache.pulsar.broker.transaction.buffer.metadata.v2.TransactionBufferSnapshotSegment;
import org.apache.pulsar.common.events.EventType;

public class TransactionBufferSnapshotServiceFactory {
    private SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshot> txnBufferSnapshotService;
    private SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotSegment> txnBufferSnapshotSegmentService;
    private SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotIndexes> txnBufferSnapshotIndexService;

    public TransactionBufferSnapshotServiceFactory(PulsarService pulsar) throws PulsarServerException {
        this.txnBufferSnapshotSegmentService = new SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotSegment>(pulsar, EventType.TRANSACTION_BUFFER_SNAPSHOT_SEGMENTS, TransactionBufferSnapshotSegment.class);
        this.txnBufferSnapshotIndexService = new SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotIndexes>(pulsar, EventType.TRANSACTION_BUFFER_SNAPSHOT_INDEXES, TransactionBufferSnapshotIndexes.class);
        this.txnBufferSnapshotService = new SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshot>(pulsar, EventType.TRANSACTION_BUFFER_SNAPSHOT, TransactionBufferSnapshot.class);
    }

    public void close() throws Exception {
        if (this.txnBufferSnapshotIndexService != null) {
            this.txnBufferSnapshotIndexService.close();
            this.txnBufferSnapshotIndexService = null;
        }
        if (this.txnBufferSnapshotSegmentService != null) {
            this.txnBufferSnapshotSegmentService.close();
            this.txnBufferSnapshotSegmentService = null;
        }
        if (this.txnBufferSnapshotService != null) {
            this.txnBufferSnapshotService.close();
            this.txnBufferSnapshotService = null;
        }
    }

    public SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshot> getTxnBufferSnapshotService() {
        return this.txnBufferSnapshotService;
    }

    public SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotSegment> getTxnBufferSnapshotSegmentService() {
        return this.txnBufferSnapshotSegmentService;
    }

    public SystemTopicTxnBufferSnapshotService<TransactionBufferSnapshotIndexes> getTxnBufferSnapshotIndexService() {
        return this.txnBufferSnapshotIndexService;
    }
}

