/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class ManagedLedgerMetrics
extends AbstractMetrics {
    private List<Metrics> metricsCollection = new ArrayList<Metrics>();
    private Map<Metrics, List<ManagedLedger>> ledgersByDimensionMap = new HashMap<Metrics, List<ManagedLedger>>();
    private Map<String, Double> tempAggregatedMetricsMap = new HashMap<String, Double>();
    private static final AbstractMetrics.Buckets BRK_ML_ADDENTRYLATENCYBUCKETS = new AbstractMetrics.Buckets("brk_ml_AddEntryLatencyBuckets", ENTRY_LATENCY_BUCKETS_MS);
    private static final AbstractMetrics.Buckets BRK_ML_LEDGERADDENTRYLATENCYBUCKETS = new AbstractMetrics.Buckets("brk_ml_LedgerAddEntryLatencyBuckets", ENTRY_LATENCY_BUCKETS_MS);
    private static final AbstractMetrics.Buckets BRK_ML_LEDGERSWITCHLATENCYBUCKETS = new AbstractMetrics.Buckets("brk_ml_LedgerSwitchLatencyBuckets", ENTRY_LATENCY_BUCKETS_MS);
    private static final AbstractMetrics.Buckets BRK_ML_ENTRYSIZEBUCKETS = new AbstractMetrics.Buckets("brk_ml_EntrySizeBuckets", ENTRY_SIZE_BUCKETS_BYTES);
    private int statsPeriodSeconds;

    public ManagedLedgerMetrics(PulsarService pulsar) {
        super(pulsar);
        this.statsPeriodSeconds = pulsar.getManagedLedgerFactory().getConfig().getStatsPeriodSeconds();
    }

    @Override
    public synchronized List<Metrics> generate() {
        return this.aggregate(this.groupLedgersByDimension());
    }

    private List<Metrics> aggregate(Map<Metrics, List<ManagedLedger>> ledgersByDimension) {
        this.metricsCollection.clear();
        for (Map.Entry<Metrics, List<ManagedLedger>> e : ledgersByDimension.entrySet()) {
            Metrics metrics = e.getKey();
            List<ManagedLedger> ledgers = e.getValue();
            this.tempAggregatedMetricsMap.clear();
            for (ManagedLedger managedLedger : ledgers) {
                ManagedLedgerMXBean lStats = managedLedger.getStats();
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryBytesRate", lStats.getAddEntryBytesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryWithReplicasBytesRate", lStats.getAddEntryWithReplicasBytesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryErrors", lStats.getAddEntryErrors());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryMessagesRate", lStats.getAddEntryMessagesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntrySucceed", lStats.getAddEntrySucceed());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_NumberOfMessagesInBacklog", lStats.getNumberOfMessagesInBacklog());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesBytesRate", lStats.getReadEntriesBytesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesErrors", lStats.getReadEntriesErrors());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesRate", lStats.getReadEntriesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesOpsCacheMissesRate", lStats.getReadEntriesOpsCacheMissesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesSucceeded", lStats.getReadEntriesSucceeded());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_StoredMessagesSize", lStats.getStoredMessagesSize());
                BRK_ML_ADDENTRYLATENCYBUCKETS.populateBucketEntries(this.tempAggregatedMetricsMap, lStats.getAddEntryLatencyBuckets(), this.statsPeriodSeconds);
                BRK_ML_LEDGERADDENTRYLATENCYBUCKETS.populateBucketEntries(this.tempAggregatedMetricsMap, lStats.getLedgerAddEntryLatencyBuckets(), this.statsPeriodSeconds);
                BRK_ML_LEDGERSWITCHLATENCYBUCKETS.populateBucketEntries(this.tempAggregatedMetricsMap, lStats.getLedgerSwitchLatencyBuckets(), this.statsPeriodSeconds);
                BRK_ML_ENTRYSIZEBUCKETS.populateBucketEntries(this.tempAggregatedMetricsMap, lStats.getEntrySizeBuckets(), this.statsPeriodSeconds);
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_MarkDeleteRate", lStats.getMarkDeleteRate());
            }
            for (Map.Entry entry : this.tempAggregatedMetricsMap.entrySet()) {
                metrics.put((String)entry.getKey(), entry.getValue());
            }
            this.metricsCollection.add(metrics);
        }
        return this.metricsCollection;
    }

    private Map<Metrics, List<ManagedLedger>> groupLedgersByDimension() {
        this.ledgersByDimensionMap.clear();
        for (Map.Entry<String, ManagedLedger> e : this.getManagedLedgers().entrySet()) {
            String ledgerName = e.getKey();
            ManagedLedger ledger = e.getValue();
            String namespace = this.parseNamespaceFromLedgerName(ledgerName);
            Metrics metrics = this.createMetricsByDimension(namespace);
            this.populateDimensionMap(this.ledgersByDimensionMap, metrics, ledger);
        }
        return this.ledgersByDimensionMap;
    }
}

