/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.ConsumerInterceptor;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.client.api.v2.Consumer;
import org.apache.pulsar.shade.client.api.v2.MessageListener;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ConsumerBuilderImpl<T>
implements ConsumerBuilder<T> {
    private final PulsarClientImpl client;
    private ConsumerConfigurationData<T> conf;
    private final Schema<T> schema;
    private List<ConsumerInterceptor<T>> interceptorList;
    private static long MIN_ACK_TIMEOUT_MILLIS = 1000L;
    private static long DEFAULT_ACK_TIMEOUT_MILLIS_FOR_DEAD_LETTER = 30000L;

    public ConsumerBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ConsumerConfigurationData(), schema);
    }

    ConsumerBuilderImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, Schema<T> schema) {
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    @Override
    public ConsumerBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ConsumerConfigurationData.class);
        return this;
    }

    @Override
    public ConsumerBuilder<T> clone() {
        return new ConsumerBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    @Override
    public Consumer<T> subscribe() throws PulsarClientException {
        try {
            return this.subscribeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public CompletableFuture<Consumer<T>> subscribeAsync() {
        if (this.conf.getTopicNames().isEmpty() && this.conf.getTopicsPattern() == null) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidConfigurationException("Topic name must be set on the consumer builder"));
        }
        if (StringUtils.isBlank(this.conf.getSubscriptionName())) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidConfigurationException("Subscription name must be set on the consumer builder"));
        }
        return this.interceptorList == null || this.interceptorList.size() == 0 ? this.client.subscribeAsync(this.conf, this.schema, null) : this.client.subscribeAsync(this.conf, this.schema, new ConsumerInterceptors<T>(this.interceptorList));
    }

    @Override
    public ConsumerBuilder<T> topic(String ... topicNames) {
        Preconditions.checkArgument(topicNames != null && topicNames.length > 0, "Passed in topicNames should not be null or empty.");
        Arrays.stream(topicNames).forEach(topicName -> Preconditions.checkArgument(StringUtils.isNotBlank(topicName), "topicNames cannot have blank topic"));
        this.conf.getTopicNames().addAll(Lists.newArrayList(topicNames));
        return this;
    }

    @Override
    public ConsumerBuilder<T> topics(List<String> topicNames) {
        Preconditions.checkArgument(topicNames != null && !topicNames.isEmpty(), "Passed in topicNames list should not be null or empty.");
        topicNames.stream().forEach(topicName -> Preconditions.checkArgument(StringUtils.isNotBlank(topicName), "topicNames cannot have blank topic"));
        this.conf.getTopicNames().addAll(topicNames);
        return this;
    }

    @Override
    public ConsumerBuilder<T> topicsPattern(Pattern topicsPattern) {
        Preconditions.checkArgument(this.conf.getTopicsPattern() == null, "Pattern has already been set.");
        this.conf.setTopicsPattern(topicsPattern);
        return this;
    }

    @Override
    public ConsumerBuilder<T> topicsPattern(String topicsPattern) {
        Preconditions.checkArgument(this.conf.getTopicsPattern() == null, "Pattern has already been set.");
        this.conf.setTopicsPattern(Pattern.compile(topicsPattern));
        return this;
    }

    @Override
    public ConsumerBuilder<T> subscriptionName(String subscriptionName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(subscriptionName), "subscriptionName cannot be blank");
        this.conf.setSubscriptionName(subscriptionName);
        return this;
    }

    @Override
    public ConsumerBuilder<T> ackTimeout(long ackTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeUnit.toMillis(ackTimeout) >= MIN_ACK_TIMEOUT_MILLIS, "Ack timeout should be should be greater than " + MIN_ACK_TIMEOUT_MILLIS + " ms");
        this.conf.setAckTimeoutMillis(timeUnit.toMillis(ackTimeout));
        return this;
    }

    @Override
    public ConsumerBuilder<T> subscriptionType(@NonNull SubscriptionType subscriptionType) {
        if (subscriptionType == null) {
            throw new NullPointerException("subscriptionType is marked @NonNull but is null");
        }
        this.conf.setSubscriptionType(subscriptionType);
        return this;
    }

    @Override
    public ConsumerBuilder<T> messageListener(@NonNull MessageListener<T> messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener is marked @NonNull but is null");
        }
        this.conf.setMessageListener(messageListener);
        return this;
    }

    @Override
    public ConsumerBuilder<T> consumerEventListener(@NonNull ConsumerEventListener consumerEventListener) {
        if (consumerEventListener == null) {
            throw new NullPointerException("consumerEventListener is marked @NonNull but is null");
        }
        this.conf.setConsumerEventListener(consumerEventListener);
        return this;
    }

    @Override
    public ConsumerBuilder<T> cryptoKeyReader(@NonNull CryptoKeyReader cryptoKeyReader) {
        if (cryptoKeyReader == null) {
            throw new NullPointerException("cryptoKeyReader is marked @NonNull but is null");
        }
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    @Override
    public ConsumerBuilder<T> cryptoFailureAction(@NonNull ConsumerCryptoFailureAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked @NonNull but is null");
        }
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    @Override
    public ConsumerBuilder<T> receiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "receiverQueueSize needs to be >= 0");
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    @Override
    public ConsumerBuilder<T> acknowledgmentGroupTime(long delay, TimeUnit unit) {
        Preconditions.checkArgument(delay >= 0L, "acknowledgmentGroupTime needs to be >= 0");
        this.conf.setAcknowledgementsGroupTimeMicros(unit.toMicros(delay));
        return this;
    }

    @Override
    public ConsumerBuilder<T> consumerName(String consumerName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(consumerName), "consumerName cannot be blank");
        this.conf.setConsumerName(consumerName);
        return this;
    }

    @Override
    public ConsumerBuilder<T> priorityLevel(int priorityLevel) {
        this.conf.setPriorityLevel(priorityLevel);
        return this;
    }

    @Override
    public ConsumerBuilder<T> property(String key, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value), "property key/value cannot be blank");
        this.conf.getProperties().put(key, value);
        return this;
    }

    @Override
    public ConsumerBuilder<T> properties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        Preconditions.checkArgument(!properties.isEmpty(), "properties cannot be empty");
        properties.entrySet().forEach(entry -> Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)entry.getKey()) && StringUtils.isNotBlank((CharSequence)entry.getValue()), "properties' key/value cannot be blank"));
        this.conf.getProperties().putAll(properties);
        return this;
    }

    @Override
    public ConsumerBuilder<T> maxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        this.conf.setMaxTotalReceiverQueueSizeAcrossPartitions(maxTotalReceiverQueueSizeAcrossPartitions);
        return this;
    }

    @Override
    public ConsumerBuilder<T> readCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    @Override
    public ConsumerBuilder<T> patternAutoDiscoveryPeriod(int periodInMinutes) {
        this.conf.setPatternAutoDiscoveryPeriod(periodInMinutes);
        return this;
    }

    @Override
    public ConsumerBuilder<T> subscriptionInitialPosition(@NonNull SubscriptionInitialPosition subscriptionInitialPosition) {
        if (subscriptionInitialPosition == null) {
            throw new NullPointerException("subscriptionInitialPosition is marked @NonNull but is null");
        }
        this.conf.setSubscriptionInitialPosition(subscriptionInitialPosition);
        return this;
    }

    @Override
    public ConsumerBuilder<T> subscriptionTopicsMode(@NonNull RegexSubscriptionMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked @NonNull but is null");
        }
        this.conf.setRegexSubscriptionMode(mode);
        return this;
    }

    @Override
    public ConsumerBuilder<T> intercept(ConsumerInterceptor<T> ... interceptors) {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<ConsumerInterceptor<T>>();
        }
        this.interceptorList.addAll(Arrays.asList(interceptors));
        return this;
    }

    @Override
    public ConsumerBuilder<T> deadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        if (deadLetterPolicy != null) {
            if (this.conf.getAckTimeoutMillis() == 0L) {
                this.conf.setAckTimeoutMillis(DEFAULT_ACK_TIMEOUT_MILLIS_FOR_DEAD_LETTER);
            }
            this.conf.setDeadLetterPolicy(deadLetterPolicy);
        }
        return this;
    }

    @Override
    public ConsumerBuilder<T> autoUpdatePartitions(boolean autoUpdate) {
        this.conf.setAutoUpdatePartitions(autoUpdate);
        return this;
    }

    public ConsumerConfigurationData<T> getConf() {
        return this.conf;
    }
}

